/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;

public abstract class PacketPlayInFlying
implements Packet<PacketListenerPlayIn> {
    public final double x;
    public final double y;
    public final double z;
    public final float yRot;
    public final float xRot;
    protected final boolean onGround;
    public final boolean hasPos;
    public final boolean hasRot;

    protected PacketPlayInFlying(double var0, double var2, double var4, float var6, float var7, boolean var8, boolean var9, boolean var10) {
        this.x = var0;
        this.y = var2;
        this.z = var4;
        this.yRot = var6;
        this.xRot = var7;
        this.onGround = var8;
        this.hasPos = var9;
        this.hasRot = var10;
    }

    @Override
    public abstract PacketType<? extends PacketPlayInFlying> type();

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleMovePlayer(this);
    }

    public double getX(double var0) {
        return this.hasPos ? this.x : var0;
    }

    public double getY(double var0) {
        return this.hasPos ? this.y : var0;
    }

    public double getZ(double var0) {
        return this.hasPos ? this.z : var0;
    }

    public float getYRot(float var0) {
        return this.hasRot ? this.yRot : var0;
    }

    public float getXRot(float var0) {
        return this.hasRot ? this.xRot : var0;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean hasPosition() {
        return this.hasPos;
    }

    public boolean hasRotation() {
        return this.hasRot;
    }

    public static class d
    extends PacketPlayInFlying {
        public static final StreamCodec<PacketDataSerializer, d> STREAM_CODEC = Packet.codec(d::write, d::read);

        public d(boolean var0) {
            super(0.0, 0.0, 0.0, 0.0f, 0.0f, var0, false, false);
        }

        private static d read(PacketDataSerializer var0) {
            boolean var1 = var0.readUnsignedByte() != 0;
            return new d(var1);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        public PacketType<d> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_STATUS_ONLY;
        }
    }

    public static class PacketPlayInLook
    extends PacketPlayInFlying {
        public static final StreamCodec<PacketDataSerializer, PacketPlayInLook> STREAM_CODEC = Packet.codec(PacketPlayInLook::write, PacketPlayInLook::read);

        public PacketPlayInLook(float var0, float var1, boolean var2) {
            super(0.0, 0.0, 0.0, var0, var1, var2, false, true);
        }

        private static PacketPlayInLook read(PacketDataSerializer var0) {
            float var1 = var0.readFloat();
            float var2 = var0.readFloat();
            boolean var3 = var0.readUnsignedByte() != 0;
            return new PacketPlayInLook(var1, var2, var3);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeFloat(this.yRot);
            var0.writeFloat(this.xRot);
            var0.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        public PacketType<PacketPlayInLook> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_ROT;
        }
    }

    public static class PacketPlayInPosition
    extends PacketPlayInFlying {
        public static final StreamCodec<PacketDataSerializer, PacketPlayInPosition> STREAM_CODEC = Packet.codec(PacketPlayInPosition::write, PacketPlayInPosition::read);

        public PacketPlayInPosition(double var0, double var2, double var4, boolean var6) {
            super(var0, var2, var4, 0.0f, 0.0f, var6, true, false);
        }

        private static PacketPlayInPosition read(PacketDataSerializer var0) {
            double var1 = var0.readDouble();
            double var3 = var0.readDouble();
            double var5 = var0.readDouble();
            boolean var7 = var0.readUnsignedByte() != 0;
            return new PacketPlayInPosition(var1, var3, var5, var7);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeDouble(this.x);
            var0.writeDouble(this.y);
            var0.writeDouble(this.z);
            var0.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        public PacketType<PacketPlayInPosition> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS;
        }
    }

    public static class PacketPlayInPositionLook
    extends PacketPlayInFlying {
        public static final StreamCodec<PacketDataSerializer, PacketPlayInPositionLook> STREAM_CODEC = Packet.codec(PacketPlayInPositionLook::write, PacketPlayInPositionLook::read);

        public PacketPlayInPositionLook(double var0, double var2, double var4, float var6, float var7, boolean var8) {
            super(var0, var2, var4, var6, var7, var8, true, true);
        }

        private static PacketPlayInPositionLook read(PacketDataSerializer var0) {
            double var1 = var0.readDouble();
            double var3 = var0.readDouble();
            double var5 = var0.readDouble();
            float var7 = var0.readFloat();
            float var8 = var0.readFloat();
            boolean var9 = var0.readUnsignedByte() != 0;
            return new PacketPlayInPositionLook(var1, var3, var5, var7, var8, var9);
        }

        private void write(PacketDataSerializer var0) {
            var0.writeDouble(this.x);
            var0.writeDouble(this.y);
            var0.writeDouble(this.z);
            var0.writeFloat(this.yRot);
            var0.writeFloat(this.xRot);
            var0.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        public PacketType<PacketPlayInPositionLook> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS_ROT;
        }
    }
}

