/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;

public interface PacketListener {
    public EnumProtocolDirection flow();

    public EnumProtocol protocol();

    public void onDisconnect(DisconnectionDetails var1);

    default public void onPacketError(Packet var0, Exception var1) throws ReportedException {
        throw PlayerConnectionUtils.makeReportedException(var1, var0, this);
    }

    default public DisconnectionDetails createDisconnectionInfo(IChatBaseComponent var0, Throwable var1) {
        return new DisconnectionDetails(var0);
    }

    public boolean isAcceptingMessages();

    default public boolean shouldHandleMessage(Packet<?> var0) {
        return this.isAcceptingMessages();
    }

    default public void fillCrashReport(CrashReport var0) {
        CrashReportSystemDetails var1 = var0.addCategory("Connection");
        var1.setDetail("Protocol", () -> this.protocol().id());
        var1.setDetail("Flow", () -> this.flow().toString());
        this.fillListenerSpecificCrashDetails(var0, var1);
    }

    default public void fillListenerSpecificCrashDetails(CrashReport var0, CrashReportSystemDetails var1) {
    }
}

