/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessHelper;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTimeout;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.ticks.TickListServer;

public class GameTestHarnessInfo {
    private final GameTestHarnessTestFunction testFunction;
    @Nullable
    private BlockPosition structureBlockPos;
    @Nullable
    private BlockPosition northWestCorner;
    private final WorldServer level;
    private final Collection<GameTestHarnessListener> listeners = Lists.newArrayList();
    private final int timeoutTicks;
    private final Collection<GameTestHarnessSequence> sequences = Lists.newCopyOnWriteArrayList();
    private final Object2LongMap<Runnable> runAtTickTimeMap = new Object2LongOpenHashMap();
    private long startTick;
    private int ticksToWaitForChunkLoading = 20;
    private boolean placedStructure;
    private boolean chunksLoaded;
    private long tickCount;
    private boolean started;
    private final RetryOptions retryOptions;
    private final Stopwatch timer = Stopwatch.createUnstarted();
    private boolean done;
    private final EnumBlockRotation rotation;
    @Nullable
    private Throwable error;
    @Nullable
    private TileEntityStructure structureBlockEntity;

    public GameTestHarnessInfo(GameTestHarnessTestFunction var0, EnumBlockRotation var1, WorldServer var2, RetryOptions var3) {
        this.testFunction = var0;
        this.level = var2;
        this.retryOptions = var3;
        this.timeoutTicks = var0.maxTicks();
        this.rotation = var0.rotation().getRotated(var1);
    }

    void setStructureBlockPos(BlockPosition var0) {
        this.structureBlockPos = var0;
    }

    public GameTestHarnessInfo startExecution(int var0) {
        this.startTick = this.level.getGameTime() + this.testFunction.setupTicks() + (long)var0;
        this.timer.start();
        return this;
    }

    public GameTestHarnessInfo placeStructure() {
        if (this.placedStructure) {
            return this;
        }
        this.ticksToWaitForChunkLoading = 0;
        this.placedStructure = true;
        TileEntityStructure var0 = this.getStructureBlockEntity();
        var0.placeStructure(this.level);
        StructureBoundingBox var1 = GameTestHarnessStructures.getStructureBoundingBox(var0);
        ((TickListServer)this.level.getBlockTicks()).clearArea(var1);
        this.level.clearBlockEvents(var1);
        return this;
    }

    private boolean ensureStructureIsPlaced() {
        if (this.placedStructure) {
            return true;
        }
        if (this.ticksToWaitForChunkLoading > 0) {
            --this.ticksToWaitForChunkLoading;
            return false;
        }
        this.placeStructure().startExecution(0);
        return true;
    }

    public void tick(GameTestHarnessRunner var02) {
        if (this.isDone()) {
            return;
        }
        if (this.structureBlockEntity == null) {
            this.fail(new IllegalStateException("Running test without structure block entity"));
        }
        if (!this.chunksLoaded && !GameTestHarnessStructures.getStructureBoundingBox(this.structureBlockEntity).intersectingChunks().allMatch(var0 -> this.level.isPositionEntityTicking(var0.getWorldPosition()))) {
            return;
        }
        this.chunksLoaded = true;
        if (!this.ensureStructureIsPlaced()) {
            return;
        }
        this.tickInternal();
        if (this.isDone()) {
            if (this.error != null) {
                this.listeners.forEach(var1 -> var1.testFailed(this, var02));
            } else {
                this.listeners.forEach(var1 -> var1.testPassed(this, var02));
            }
        }
    }

    private void tickInternal() {
        this.tickCount = this.level.getGameTime() - this.startTick;
        if (this.tickCount < 0L) {
            return;
        }
        if (!this.started) {
            this.startTest();
        }
        ObjectIterator var02 = this.runAtTickTimeMap.object2LongEntrySet().iterator();
        while (var02.hasNext()) {
            Object2LongMap.Entry var1 = (Object2LongMap.Entry)var02.next();
            if (var1.getLongValue() > this.tickCount) continue;
            try {
                ((Runnable)var1.getKey()).run();
            }
            catch (Exception var2) {
                this.fail(var2);
            }
            var02.remove();
        }
        if (this.tickCount > (long)this.timeoutTicks) {
            if (this.sequences.isEmpty()) {
                this.fail(new GameTestHarnessTimeout("Didn't succeed or fail within " + this.testFunction.maxTicks() + " ticks"));
            } else {
                this.sequences.forEach(var0 -> var0.tickAndFailIfNotComplete(this.tickCount));
                if (this.error == null) {
                    this.fail(new GameTestHarnessTimeout("No sequences finished"));
                }
            }
        } else {
            this.sequences.forEach(var0 -> var0.tickAndContinue(this.tickCount));
        }
    }

    private void startTest() {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            this.testFunction.run(new GameTestHarnessHelper(this));
        }
        catch (Exception var0) {
            this.fail(var0);
        }
    }

    public void setRunAtTickTime(long var0, Runnable var2) {
        this.runAtTickTimeMap.put((Object)var2, var0);
    }

    public String getTestName() {
        return this.testFunction.testName();
    }

    @Nullable
    public BlockPosition getStructureBlockPos() {
        return this.structureBlockPos;
    }

    public AxisAlignedBB getStructureBounds() {
        TileEntityStructure var0 = this.getStructureBlockEntity();
        return GameTestHarnessStructures.getStructureBounds(var0);
    }

    public TileEntityStructure getStructureBlockEntity() {
        if (this.structureBlockEntity == null) {
            if (this.structureBlockPos == null) {
                throw new IllegalStateException("Could not find a structureBlockEntity for this GameTestInfo");
            }
            this.structureBlockEntity = (TileEntityStructure)this.level.getBlockEntity(this.structureBlockPos);
            if (this.structureBlockEntity == null) {
                throw new IllegalStateException("Could not find a structureBlockEntity at the given coordinate " + String.valueOf(this.structureBlockPos));
            }
        }
        return this.structureBlockEntity;
    }

    public WorldServer getLevel() {
        return this.level;
    }

    public boolean hasSucceeded() {
        return this.done && this.error == null;
    }

    public boolean hasFailed() {
        return this.error != null;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public boolean isDone() {
        return this.done;
    }

    public long getRunTime() {
        return this.timer.elapsed(TimeUnit.MILLISECONDS);
    }

    private void finish() {
        if (!this.done) {
            this.done = true;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    public void succeed() {
        if (this.error == null) {
            this.finish();
            AxisAlignedBB var02 = this.getStructureBounds();
            List<Entity> var1 = this.getLevel().getEntitiesOfClass(Entity.class, var02.inflate(1.0), var0 -> !(var0 instanceof EntityHuman));
            var1.forEach(var0 -> var0.remove(Entity.RemovalReason.DISCARDED));
        }
    }

    public void fail(Throwable var0) {
        this.error = var0;
        this.finish();
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public String toString() {
        return this.getTestName();
    }

    public void addListener(GameTestHarnessListener var0) {
        this.listeners.add(var0);
    }

    public GameTestHarnessInfo prepareTestStructure() {
        BlockPosition var02 = this.getOrCalculateNorthwestCorner();
        this.structureBlockEntity = GameTestHarnessStructures.prepareTestStructure(this, var02, this.getRotation(), this.level);
        this.structureBlockPos = this.structureBlockEntity.getBlockPos();
        GameTestHarnessStructures.addCommandBlockAndButtonToStartTest(this.structureBlockPos, new BlockPosition(1, 0, -1), this.getRotation(), this.level);
        GameTestHarnessStructures.encaseStructure(this.getStructureBounds(), this.level, !this.testFunction.skyAccess());
        this.listeners.forEach(var0 -> var0.testStructureLoaded(this));
        return this;
    }

    long getTick() {
        return this.tickCount;
    }

    GameTestHarnessSequence createSequence() {
        GameTestHarnessSequence var0 = new GameTestHarnessSequence(this);
        this.sequences.add(var0);
        return var0;
    }

    public boolean isRequired() {
        return this.testFunction.required();
    }

    public boolean isOptional() {
        return !this.testFunction.required();
    }

    public String getStructureName() {
        return this.testFunction.structureName();
    }

    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public GameTestHarnessTestFunction getTestFunction() {
        return this.testFunction;
    }

    public int getTimeoutTicks() {
        return this.timeoutTicks;
    }

    public boolean isFlaky() {
        return this.testFunction.isFlaky();
    }

    public int maxAttempts() {
        return this.testFunction.maxAttempts();
    }

    public int requiredSuccesses() {
        return this.testFunction.requiredSuccesses();
    }

    public RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public Stream<GameTestHarnessListener> getListeners() {
        return this.listeners.stream();
    }

    public GameTestHarnessInfo copyReset() {
        GameTestHarnessInfo var0 = new GameTestHarnessInfo(this.testFunction, this.rotation, this.level, this.retryOptions());
        if (this.northWestCorner != null) {
            var0.setNorthWestCorner(this.northWestCorner);
        }
        if (this.structureBlockPos != null) {
            var0.setStructureBlockPos(this.structureBlockPos);
        }
        return var0;
    }

    private BlockPosition getOrCalculateNorthwestCorner() {
        if (this.northWestCorner == null) {
            StructureBoundingBox var0 = GameTestHarnessStructures.getStructureBoundingBox(this.getStructureBlockEntity());
            this.northWestCorner = new BlockPosition(var0.minX(), var0.minY(), var0.minZ());
        }
        return this.northWestCorner;
    }

    public void setNorthWestCorner(BlockPosition var0) {
        this.northWestCorner = var0;
    }
}

