/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class ParticleParamItem
implements ParticleParam {
    private static final Codec<ItemStack> ITEM_CODEC = Codec.withAlternative(ItemStack.SINGLE_ITEM_CODEC, ItemStack.ITEM_NON_AIR_CODEC, ItemStack::new);
    private final Particle<ParticleParamItem> type;
    private final ItemStack itemStack;

    public static MapCodec<ParticleParamItem> codec(Particle<ParticleParamItem> var02) {
        return ITEM_CODEC.xmap(var1 -> new ParticleParamItem(var02, (ItemStack)var1), var0 -> var0.itemStack).fieldOf("item");
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, ParticleParamItem> streamCodec(Particle<ParticleParamItem> var02) {
        return ItemStack.STREAM_CODEC.map(var1 -> new ParticleParamItem(var02, (ItemStack)var1), var0 -> var0.itemStack);
    }

    public ParticleParamItem(Particle<ParticleParamItem> var0, ItemStack var1) {
        if (var1.isEmpty()) {
            throw new IllegalArgumentException("Empty stacks are not allowed");
        }
        this.type = var0;
        this.itemStack = var1;
    }

    public Particle<ParticleParamItem> getType() {
        return this.type;
    }

    public ItemStack getItem() {
        return this.itemStack;
    }
}

