/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;

public class DustColorTransitionOptions
extends DustParticleOptionsBase {
    public static final Vector3f SCULK_PARTICLE_COLOR = Vec3D.fromRGB24(3790560).toVector3f();
    public static final DustColorTransitionOptions SCULK_TO_REDSTONE = new DustColorTransitionOptions(SCULK_PARTICLE_COLOR, ParticleParamRedstone.REDSTONE_PARTICLE_COLOR, 1.0f);
    public static final MapCodec<DustColorTransitionOptions> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ExtraCodecs.VECTOR3F.fieldOf("from_color").forGetter(var0 -> var0.fromColor), (App)ExtraCodecs.VECTOR3F.fieldOf("to_color").forGetter(var0 -> var0.toColor), (App)SCALE.fieldOf("scale").forGetter(DustParticleOptionsBase::getScale)).apply((Applicative)var02, DustColorTransitionOptions::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DustColorTransitionOptions> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VECTOR3F, var0 -> var0.fromColor, ByteBufCodecs.VECTOR3F, var0 -> var0.toColor, ByteBufCodecs.FLOAT, DustParticleOptionsBase::getScale, DustColorTransitionOptions::new);
    private final Vector3f fromColor;
    private final Vector3f toColor;

    public DustColorTransitionOptions(Vector3f var0, Vector3f var1, float var2) {
        super(var2);
        this.fromColor = var0;
        this.toColor = var1;
    }

    public Vector3f getFromColor() {
        return this.fromColor;
    }

    public Vector3f getToColor() {
        return this.toColor;
    }

    public Particle<DustColorTransitionOptions> getType() {
        return Particles.DUST_COLOR_TRANSITION;
    }
}

