/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

public interface IRegistryCustom
extends HolderLookup.a {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Dimension EMPTY = new c(Map.of()).freeze();

    public <E> Optional<IRegistry<E>> registry(ResourceKey<? extends IRegistry<? extends E>> var1);

    @Override
    default public <T> Optional<HolderLookup.b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var0) {
        return this.registry(var0).map(IRegistry::asLookup);
    }

    default public <E> IRegistry<E> registryOrThrow(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.registry(var0).orElseThrow(() -> new IllegalStateException("Missing registry: " + String.valueOf(var0)));
    }

    public Stream<d<?>> registries();

    @Override
    default public Stream<ResourceKey<? extends IRegistry<?>>> listRegistries() {
        return this.registries().map(d::key);
    }

    public static Dimension fromRegistryOfRegistries(final IRegistry<? extends IRegistry<?>> var0) {
        return new Dimension(){

            public <T> Optional<IRegistry<T>> registry(ResourceKey<? extends IRegistry<? extends T>> var02) {
                IRegistry var1 = var0;
                return var1.getOptional(var02);
            }

            @Override
            public Stream<d<?>> registries() {
                return var0.entrySet().stream().map(d::fromMapEntry);
            }

            @Override
            public Dimension freeze() {
                return this;
            }
        };
    }

    default public Dimension freeze() {
        class A
        extends c
        implements Dimension {
            protected A(IRegistryCustom var0, Stream var1) {
                super(var1);
            }
        }
        return new A(this, this.registries().map(d::freeze));
    }

    default public Lifecycle allRegistriesLifecycle() {
        return this.registries().map(var0 -> var0.value.registryLifecycle()).reduce(Lifecycle.stable(), Lifecycle::add);
    }

    public static final class d<T>
    extends Record {
        private final ResourceKey<? extends IRegistry<T>> key;
        final IRegistry<T> value;

        public d(ResourceKey<? extends IRegistry<T>> var0, IRegistry<T> var1) {
            this.key = var0;
            this.value = var1;
        }

        private static <T, R extends IRegistry<? extends T>> d<T> fromMapEntry(Map.Entry<? extends ResourceKey<? extends IRegistry<?>>, R> var0) {
            return d.fromUntyped(var0.getKey(), (IRegistry)var0.getValue());
        }

        private static <T> d<T> fromUntyped(ResourceKey<? extends IRegistry<?>> var0, IRegistry<?> var1) {
            return new d(var0, var1);
        }

        private d<T> freeze() {
            return new d<T>(this.key, this.value.freeze());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "key;value", "key", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "key;value", "key", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "key;value", "key", "value"}, this, var0);
        }

        public ResourceKey<? extends IRegistry<T>> key() {
            return this.key;
        }

        public IRegistry<T> value() {
            return this.value;
        }
    }

    public static class c
    implements IRegistryCustom {
        private final Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistry<?>> registries;

        public c(List<? extends IRegistry<?>> var02) {
            this.registries = var02.stream().collect(Collectors.toUnmodifiableMap(IRegistry::key, var0 -> var0));
        }

        public c(Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends IRegistry<?>> var0) {
            this.registries = Map.copyOf(var0);
        }

        public c(Stream<d<?>> var0) {
            this.registries = (Map)var0.collect(ImmutableMap.toImmutableMap(d::key, d::value));
        }

        @Override
        public <E> Optional<IRegistry<E>> registry(ResourceKey<? extends IRegistry<? extends E>> var02) {
            return Optional.ofNullable(this.registries.get(var02)).map(var0 -> var0);
        }

        @Override
        public Stream<d<?>> registries() {
            return this.registries.entrySet().stream().map(d::fromMapEntry);
        }
    }

    public static interface Dimension
    extends IRegistryCustom {
    }
}

