/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.DataVersion;
import org.slf4j.Logger;

public class MinecraftVersion
implements WorldVersion {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final WorldVersion BUILT_IN = new MinecraftVersion();
    private final String id;
    private final String name;
    private final boolean stable;
    private final DataVersion worldVersion;
    private final int protocolVersion;
    private final int resourcePackVersion;
    private final int dataPackVersion;
    private final Date buildTime;

    private MinecraftVersion() {
        this.id = UUID.randomUUID().toString().replaceAll("-", "");
        this.name = "1.21";
        this.stable = true;
        this.worldVersion = new DataVersion(3953, "main");
        this.protocolVersion = SharedConstants.getProtocolVersion();
        this.resourcePackVersion = 34;
        this.dataPackVersion = 48;
        this.buildTime = new Date();
    }

    private MinecraftVersion(JsonObject var0) {
        this.id = ChatDeserializer.getAsString(var0, "id");
        this.name = ChatDeserializer.getAsString(var0, "name");
        this.stable = ChatDeserializer.getAsBoolean(var0, "stable");
        this.worldVersion = new DataVersion(ChatDeserializer.getAsInt(var0, "world_version"), ChatDeserializer.getAsString(var0, "series_id", DataVersion.MAIN_SERIES));
        this.protocolVersion = ChatDeserializer.getAsInt(var0, "protocol_version");
        JsonObject var1 = ChatDeserializer.getAsJsonObject(var0, "pack_version");
        this.resourcePackVersion = ChatDeserializer.getAsInt(var1, "resource");
        this.dataPackVersion = ChatDeserializer.getAsInt(var1, "data");
        this.buildTime = Date.from(ZonedDateTime.parse(ChatDeserializer.getAsString(var0, "build_time")).toInstant());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static WorldVersion tryDetectVersion() {
        try (InputStream var0 = MinecraftVersion.class.getResourceAsStream("/version.json");){
            MinecraftVersion minecraftVersion;
            if (var0 == null) {
                LOGGER.warn("Missing version information!");
                WorldVersion worldVersion = BUILT_IN;
                return worldVersion;
            }
            try (InputStreamReader var1 = new InputStreamReader(var0);){
                minecraftVersion = new MinecraftVersion(ChatDeserializer.parse(var1));
            }
            return minecraftVersion;
        }
        catch (JsonParseException | IOException var02) {
            throw new IllegalStateException("Game version information is corrupt", var02);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataVersion getDataVersion() {
        return this.worldVersion;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public int getPackVersion(EnumResourcePackType var0) {
        return var0 == EnumResourcePackType.SERVER_DATA ? this.dataPackVersion : this.resourcePackVersion;
    }

    @Override
    public Date getBuildTime() {
        return this.buildTime;
    }

    @Override
    public boolean isStable() {
        return this.stable;
    }
}

