/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public record LootItemConditionTableBonus(Holder<Enchantment> enchantment, List<Float> values) implements LootItemCondition
{
    public static final MapCodec<LootItemConditionTableBonus> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BuiltInRegistries.ENCHANTMENT.holderByNameCodec().fieldOf("enchantment").forGetter(LootItemConditionTableBonus::enchantment), (App)ExtraCodecs.nonEmptyList(Codec.FLOAT.listOf()).fieldOf("chances").forGetter(LootItemConditionTableBonus::values)).apply((Applicative)var0, LootItemConditionTableBonus::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.TABLE_BONUS;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.TOOL);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        ItemStack var1 = var0.getParamOrNull(LootContextParameters.TOOL);
        int var2 = var1 != null ? EnchantmentManager.getItemEnchantmentLevel(this.enchantment.value(), var1) : 0;
        float var3 = this.values.get(Math.min(var2, this.values.size() - 1)).floatValue();
        return var0.getRandom().nextFloat() < var3;
    }

    public static LootItemCondition.a bonusLevelFlatChance(Enchantment var0, float ... var1) {
        ArrayList<Float> var2 = new ArrayList<Float>(var1.length);
        for (float var6 : var1) {
            var2.add(Float.valueOf(var6));
        }
        return () -> new LootItemConditionTableBonus(var0.builtInRegistryHolder(), var2);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }
}

