/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class WorldPersistentData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Map<String, PersistentBase> cache = Maps.newHashMap();
    private final DataFixer fixerUpper;
    private final HolderLookup.a registries;
    private final File dataFolder;

    public WorldPersistentData(File var0, DataFixer var1, HolderLookup.a var2) {
        this.fixerUpper = var1;
        this.dataFolder = var0;
        this.registries = var2;
    }

    private File getDataFile(String var0) {
        return new File(this.dataFolder, var0 + ".dat");
    }

    public <T extends PersistentBase> T computeIfAbsent(PersistentBase.a<T> var0, String var1) {
        T var2 = this.get(var0, var1);
        if (var2 != null) {
            return var2;
        }
        PersistentBase var3 = (PersistentBase)var0.constructor().get();
        this.set(var1, var3);
        return (T)var3;
    }

    @Nullable
    public <T extends PersistentBase> T get(PersistentBase.a<T> var0, String var1) {
        PersistentBase var2 = this.cache.get(var1);
        if (var2 == null && !this.cache.containsKey(var1)) {
            var2 = this.readSavedData(var0.deserializer(), var0.type(), var1);
            this.cache.put(var1, var2);
        }
        return (T)var2;
    }

    @Nullable
    private <T extends PersistentBase> T readSavedData(BiFunction<NBTTagCompound, HolderLookup.a, T> var0, DataFixTypes var1, String var2) {
        try {
            File var3 = this.getDataFile(var2);
            if (var3.exists()) {
                NBTTagCompound var4 = this.readTagFromDisk(var2, var1, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                return (T)((PersistentBase)var0.apply(var4.getCompound("data"), this.registries));
            }
        }
        catch (Exception var3) {
            LOGGER.error("Error loading saved data: {}", (Object)var2, (Object)var3);
        }
        return null;
    }

    public void set(String var0, PersistentBase var1) {
        this.cache.put(var0, var1);
    }

    public NBTTagCompound readTagFromDisk(String var0, DataFixTypes var1, int var2) throws IOException {
        File var3 = this.getDataFile(var0);
        try (FileInputStream var4 = new FileInputStream(var3);){
            NBTTagCompound nBTTagCompound;
            try (PushbackInputStream var5 = new PushbackInputStream(new FastBufferedInputStream(var4), 2);){
                NBTTagCompound var6;
                if (this.isGzip(var5)) {
                    var6 = NBTCompressedStreamTools.readCompressed(var5, NBTReadLimiter.unlimitedHeap());
                } else {
                    try (DataInputStream var7 = new DataInputStream(var5);){
                        var6 = NBTCompressedStreamTools.read(var7);
                    }
                }
                int var7 = GameProfileSerializer.getDataVersion(var6, 1343);
                nBTTagCompound = var1.update(this.fixerUpper, var6, var7, var2);
            }
            return nBTTagCompound;
        }
    }

    private boolean isGzip(PushbackInputStream var0) throws IOException {
        int var4;
        byte[] var1 = new byte[2];
        boolean var2 = false;
        int var3 = var0.read(var1, 0, 2);
        if (var3 == 2 && (var4 = (var1[1] & 0xFF) << 8 | var1[0] & 0xFF) == 35615) {
            var2 = true;
        }
        if (var3 != 0) {
            var0.unread(var1, 0, var3);
        }
        return var2;
    }

    public void save() {
        this.cache.forEach((var0, var1) -> {
            if (var1 != null) {
                var1.save(this.getDataFile((String)var0), this.registries);
            }
        });
    }
}

