/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public interface NeighborUpdater {
    public static final EnumDirection[] UPDATE_ORDER = new EnumDirection[]{EnumDirection.WEST, EnumDirection.EAST, EnumDirection.DOWN, EnumDirection.UP, EnumDirection.NORTH, EnumDirection.SOUTH};

    public void shapeUpdate(EnumDirection var1, IBlockData var2, BlockPosition var3, BlockPosition var4, int var5, int var6);

    public void neighborChanged(BlockPosition var1, Block var2, BlockPosition var3);

    public void neighborChanged(IBlockData var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5);

    default public void updateNeighborsAtExceptFromFacing(BlockPosition var0, Block var1, @Nullable EnumDirection var2) {
        for (EnumDirection var6 : UPDATE_ORDER) {
            if (var6 == var2) continue;
            this.neighborChanged(var0.relative(var6), var1, var0);
        }
    }

    public static void executeShapeUpdate(GeneratorAccess var0, EnumDirection var1, IBlockData var2, BlockPosition var3, BlockPosition var4, int var5, int var6) {
        IBlockData var7 = var0.getBlockState(var3);
        IBlockData var8 = var7.updateShape(var1, var2, var0, var3, var4);
        Block.updateOrDestroy(var7, var8, var0, var3, var5, var6);
    }

    public static void executeUpdate(World var0, IBlockData var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        try {
            var1.handleNeighborChanged(var0, var2, var3, var4, var5);
        }
        catch (Throwable var6) {
            CrashReport var7 = CrashReport.forThrowable(var6, "Exception while updating neighbours");
            CrashReportSystemDetails var8 = var7.addCategory("Block being updated");
            var8.setDetail("Source block type", () -> {
                try {
                    return String.format(Locale.ROOT, "ID #%s (%s // %s)", BuiltInRegistries.BLOCK.getKey(var3), var3.getDescriptionId(), var3.getClass().getCanonicalName());
                }
                catch (Throwable var1) {
                    return "ID #" + String.valueOf(BuiltInRegistries.BLOCK.getKey(var3));
                }
            });
            CrashReportSystemDetails.populateBlockDetails(var8, var0, var2, var1);
            throw new ReportedException(var7);
        }
    }
}

