/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.Passthrough;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;

public class DefinedStructureProcessorPredicates {
    public static final Passthrough DEFAULT_BLOCK_ENTITY_MODIFIER = Passthrough.INSTANCE;
    public static final Codec<DefinedStructureProcessorPredicates> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)DefinedStructureRuleTest.CODEC.fieldOf("input_predicate").forGetter(var0 -> var0.inputPredicate), (App)DefinedStructureRuleTest.CODEC.fieldOf("location_predicate").forGetter(var0 -> var0.locPredicate), (App)PosRuleTest.CODEC.lenientOptionalFieldOf("position_predicate", (Object)PosRuleTestTrue.INSTANCE).forGetter(var0 -> var0.posPredicate), (App)IBlockData.CODEC.fieldOf("output_state").forGetter(var0 -> var0.outputState), (App)RuleBlockEntityModifier.CODEC.lenientOptionalFieldOf("block_entity_modifier", (Object)DEFAULT_BLOCK_ENTITY_MODIFIER).forGetter(var0 -> var0.blockEntityModifier)).apply((Applicative)var02, DefinedStructureProcessorPredicates::new));
    private final DefinedStructureRuleTest inputPredicate;
    private final DefinedStructureRuleTest locPredicate;
    private final PosRuleTest posPredicate;
    private final IBlockData outputState;
    private final RuleBlockEntityModifier blockEntityModifier;

    public DefinedStructureProcessorPredicates(DefinedStructureRuleTest var0, DefinedStructureRuleTest var1, IBlockData var2) {
        this(var0, var1, PosRuleTestTrue.INSTANCE, var2);
    }

    public DefinedStructureProcessorPredicates(DefinedStructureRuleTest var0, DefinedStructureRuleTest var1, PosRuleTest var2, IBlockData var3) {
        this(var0, var1, var2, var3, DEFAULT_BLOCK_ENTITY_MODIFIER);
    }

    public DefinedStructureProcessorPredicates(DefinedStructureRuleTest var0, DefinedStructureRuleTest var1, PosRuleTest var2, IBlockData var3, RuleBlockEntityModifier var4) {
        this.inputPredicate = var0;
        this.locPredicate = var1;
        this.posPredicate = var2;
        this.outputState = var3;
        this.blockEntityModifier = var4;
    }

    public boolean test(IBlockData var0, IBlockData var1, BlockPosition var2, BlockPosition var3, BlockPosition var4, RandomSource var5) {
        return this.inputPredicate.test(var0, var5) && this.locPredicate.test(var1, var5) && this.posPredicate.test(var2, var3, var4, var5);
    }

    public IBlockData getOutputState() {
        return this.outputState;
    }

    @Nullable
    public NBTTagCompound getOutputTag(RandomSource var0, @Nullable NBTTagCompound var1) {
        return this.blockEntityModifier.apply(var0, var1);
    }
}

