/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AxisAlignedBB;

public class EntitySectionStorage<T extends EntityAccess> {
    private final Class<T> entityClass;
    private final Long2ObjectFunction<Visibility> intialSectionVisibility;
    private final Long2ObjectMap<EntitySection<T>> sections = new Long2ObjectOpenHashMap();
    private final LongSortedSet sectionIds = new LongAVLTreeSet();

    public EntitySectionStorage(Class<T> var0, Long2ObjectFunction<Visibility> var1) {
        this.entityClass = var0;
        this.intialSectionVisibility = var1;
    }

    public void forEachAccessibleNonEmptySection(AxisAlignedBB var0, AbortableIterationConsumer<EntitySection<T>> var1) {
        int var2 = 2;
        int var3 = SectionPosition.posToSectionCoord(var0.minX - 2.0);
        int var4 = SectionPosition.posToSectionCoord(var0.minY - 4.0);
        int var5 = SectionPosition.posToSectionCoord(var0.minZ - 2.0);
        int var6 = SectionPosition.posToSectionCoord(var0.maxX + 2.0);
        int var7 = SectionPosition.posToSectionCoord(var0.maxY + 0.0);
        int var8 = SectionPosition.posToSectionCoord(var0.maxZ + 2.0);
        for (int var9 = var3; var9 <= var6; ++var9) {
            long var10 = SectionPosition.asLong(var9, 0, 0);
            long var12 = SectionPosition.asLong(var9, -1, -1);
            LongBidirectionalIterator var14 = this.sectionIds.subSet(var10, var12 + 1L).iterator();
            while (var14.hasNext()) {
                EntitySection var19;
                long var15 = var14.nextLong();
                int var17 = SectionPosition.y(var15);
                int var18 = SectionPosition.z(var15);
                if (var17 < var4 || var17 > var7 || var18 < var5 || var18 > var8 || (var19 = (EntitySection)this.sections.get(var15)) == null || var19.isEmpty() || !var19.getStatus().isAccessible() || !var1.accept(var19).shouldAbort()) continue;
                return;
            }
        }
    }

    public LongStream getExistingSectionPositionsInChunk(long var0) {
        int var3;
        int var2 = ChunkCoordIntPair.getX(var0);
        LongSortedSet var4 = this.getChunkSections(var2, var3 = ChunkCoordIntPair.getZ(var0));
        if (var4.isEmpty()) {
            return LongStream.empty();
        }
        LongBidirectionalIterator var5 = var4.iterator();
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize((PrimitiveIterator.OfLong)var5, 1301), false);
    }

    private LongSortedSet getChunkSections(int var0, int var1) {
        long var2 = SectionPosition.asLong(var0, 0, var1);
        long var4 = SectionPosition.asLong(var0, -1, var1);
        return this.sectionIds.subSet(var2, var4 + 1L);
    }

    public Stream<EntitySection<T>> getExistingSectionsInChunk(long var0) {
        return this.getExistingSectionPositionsInChunk(var0).mapToObj(arg_0 -> this.sections.get(arg_0)).filter(Objects::nonNull);
    }

    private static long getChunkKeyFromSectionKey(long var0) {
        return ChunkCoordIntPair.asLong(SectionPosition.x(var0), SectionPosition.z(var0));
    }

    public EntitySection<T> getOrCreateSection(long var0) {
        return (EntitySection)this.sections.computeIfAbsent(var0, this::createSection);
    }

    @Nullable
    public EntitySection<T> getSection(long var0) {
        return (EntitySection)this.sections.get(var0);
    }

    private EntitySection<T> createSection(long var0) {
        long var2 = EntitySectionStorage.getChunkKeyFromSectionKey(var0);
        Visibility var4 = (Visibility)((Object)this.intialSectionVisibility.get(var2));
        this.sectionIds.add(var0);
        return new EntitySection<T>(this.entityClass, var4);
    }

    public LongSet getAllChunksWithExistingSections() {
        LongOpenHashSet var0 = new LongOpenHashSet();
        this.sections.keySet().forEach(arg_0 -> EntitySectionStorage.a((LongSet)var0, arg_0));
        return var0;
    }

    public void getEntities(AxisAlignedBB var0, AbortableIterationConsumer<T> var1) {
        this.forEachAccessibleNonEmptySection(var0, var2 -> var2.getEntities(var0, var1));
    }

    public <U extends T> void getEntities(EntityTypeTest<T, U> var0, AxisAlignedBB var1, AbortableIterationConsumer<U> var2) {
        this.forEachAccessibleNonEmptySection(var1, var3 -> var3.getEntities(var0, var1, var2));
    }

    public void remove(long var0) {
        this.sections.remove(var0);
        this.sectionIds.remove(var0);
    }

    @VisibleForDebug
    public int count() {
        return this.sectionIds.size();
    }

    private static /* synthetic */ void a(LongSet var0, long var1) {
        var0.add(EntitySectionStorage.getChunkKeyFromSectionKey(var1));
    }
}

