/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import org.slf4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ENTITIES_TAG = "Entities";
    private static final String POSITION_TAG = "Position";
    public final WorldServer level;
    private final SimpleRegionStorage simpleRegionStorage;
    private final LongSet emptyChunks = new LongOpenHashSet();
    public final ThreadedMailbox<Runnable> entityDeserializerQueue;

    public EntityStorage(SimpleRegionStorage var0, WorldServer var1, Executor var2) {
        this.simpleRegionStorage = var0;
        this.level = var1;
        this.entityDeserializerQueue = ThreadedMailbox.create(var2, "entity-deserializer");
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> loadEntities(ChunkCoordIntPair var0) {
        if (this.emptyChunks.contains(var0.toLong())) {
            return CompletableFuture.completedFuture(EntityStorage.emptyChunk(var0));
        }
        return this.simpleRegionStorage.read(var0).thenApplyAsync(var1 -> {
            Object var2;
            if (var1.isEmpty()) {
                this.emptyChunks.add(var0.toLong());
                return EntityStorage.emptyChunk(var0);
            }
            try {
                var2 = EntityStorage.readChunkPos((NBTTagCompound)var1.get());
                if (!Objects.equals(var0, var2)) {
                    LOGGER.error("Chunk file at {} is in the wrong location. (Expected {}, got {})", new Object[]{var0, var0, var2});
                }
            }
            catch (Exception var22) {
                LOGGER.warn("Failed to parse chunk {} position info", (Object)var0, (Object)var22);
            }
            var2 = this.simpleRegionStorage.upgradeChunkTag((NBTTagCompound)var1.get(), -1);
            NBTTagList var3 = ((NBTTagCompound)var2).getList(ENTITIES_TAG, 10);
            List var4 = (List)EntityTypes.loadEntitiesRecursive(var3, this.level).collect(ImmutableList.toImmutableList());
            return new ChunkEntities(var0, var4);
        }, this.entityDeserializerQueue::tell);
    }

    private static ChunkCoordIntPair readChunkPos(NBTTagCompound var0) {
        int[] var1 = var0.getIntArray(POSITION_TAG);
        return new ChunkCoordIntPair(var1[0], var1[1]);
    }

    private static void writeChunkPos(NBTTagCompound var0, ChunkCoordIntPair var1) {
        var0.put(POSITION_TAG, new NBTTagIntArray(new int[]{var1.x, var1.z}));
    }

    private static ChunkEntities<Entity> emptyChunk(ChunkCoordIntPair var0) {
        return new ChunkEntities<Entity>(var0, (List<Entity>)ImmutableList.of());
    }

    @Override
    public void storeEntities(ChunkEntities<Entity> var0) {
        ChunkCoordIntPair var12 = var0.getPos();
        if (var0.isEmpty()) {
            if (this.emptyChunks.add(var12.toLong())) {
                this.simpleRegionStorage.write(var12, null);
            }
            return;
        }
        NBTTagList var2 = new NBTTagList();
        var0.getEntities().forEach(var1 -> {
            NBTTagCompound var2 = new NBTTagCompound();
            if (var1.save(var2)) {
                var2.add(var2);
            }
        });
        NBTTagCompound var3 = GameProfileSerializer.addCurrentDataVersion(new NBTTagCompound());
        var3.put(ENTITIES_TAG, var2);
        EntityStorage.writeChunkPos(var3, var12);
        this.simpleRegionStorage.write(var12, var3).exceptionally(var1 -> {
            LOGGER.error("Failed to store chunk {}", (Object)var12, var1);
            return null;
        });
        this.emptyChunks.remove(var12.toLong());
    }

    @Override
    public void flush(boolean var0) {
        this.simpleRegionStorage.synchronize(var0).join();
        this.entityDeserializerQueue.runAll();
    }

    @Override
    public void close() throws IOException {
        this.simpleRegionStorage.close();
    }
}

