/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ToFullChunk;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;

public class ChunkStatusTasks {
    private static boolean isLighted(IChunkAccess var0) {
        return var0.getStatus().isOrAfter(ChunkStatus.LIGHT) && var0.isLightCorrect();
    }

    static CompletableFuture<IChunkAccess> generateEmpty(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        return CompletableFuture.completedFuture(var5);
    }

    static CompletableFuture<IChunkAccess> loadPassThrough(WorldGenContext var0, ChunkStatus var1, ToFullChunk var2, IChunkAccess var3) {
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> generateStructureStarts(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        WorldServer var6 = var0.level();
        if (var6.getServer().getWorldData().worldGenOptions().generateStructures()) {
            var0.generator().createStructures(var6.registryAccess(), var6.getChunkSource().getGeneratorState(), var6.structureManager(), var5, var0.structureManager());
        }
        var6.onStructureStartsAvailable(var5);
        return CompletableFuture.completedFuture(var5);
    }

    static CompletableFuture<IChunkAccess> loadStructureStarts(WorldGenContext var0, ChunkStatus var1, ToFullChunk var2, IChunkAccess var3) {
        var0.level().onStructureStartsAvailable(var3);
        return CompletableFuture.completedFuture(var3);
    }

    static CompletableFuture<IChunkAccess> generateStructureReferences(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        WorldServer var6 = var0.level();
        RegionLimitedWorldAccess var7 = new RegionLimitedWorldAccess(var6, var4, var1, -1);
        var0.generator().createReferences(var7, var6.structureManager().forWorldGenRegion(var7), var5);
        return CompletableFuture.completedFuture(var5);
    }

    static CompletableFuture<IChunkAccess> generateBiomes(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        WorldServer var6 = var0.level();
        RegionLimitedWorldAccess var7 = new RegionLimitedWorldAccess(var6, var4, var1, -1);
        return var0.generator().createBiomes(var2, var6.getChunkSource().randomState(), Blender.of(var7), var6.structureManager().forWorldGenRegion(var7), var5);
    }

    static CompletableFuture<IChunkAccess> generateNoise(WorldGenContext var02, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        WorldServer var6 = var02.level();
        RegionLimitedWorldAccess var7 = new RegionLimitedWorldAccess(var6, var4, var1, 0);
        return var02.generator().fillFromNoise(var2, Blender.of(var7), var6.getChunkSource().randomState(), var6.structureManager().forWorldGenRegion(var7), var5).thenApply(var0 -> {
            ProtoChunk var1;
            BelowZeroRetrogen var2;
            if (var0 instanceof ProtoChunk && (var2 = (var1 = (ProtoChunk)var0).getBelowZeroRetrogen()) != null) {
                BelowZeroRetrogen.replaceOldBedrock(var1);
                if (var2.hasBedrockHoles()) {
                    var2.applyBedrockMask(var1);
                }
            }
            return var0;
        });
    }

    static CompletableFuture<IChunkAccess> generateSurface(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        WorldServer var6 = var0.level();
        RegionLimitedWorldAccess var7 = new RegionLimitedWorldAccess(var6, var4, var1, 0);
        var0.generator().buildSurface(var7, var6.structureManager().forWorldGenRegion(var7), var6.getChunkSource().randomState(), var5);
        return CompletableFuture.completedFuture(var5);
    }

    static CompletableFuture<IChunkAccess> generateCarvers(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        WorldServer var6 = var0.level();
        RegionLimitedWorldAccess var7 = new RegionLimitedWorldAccess(var6, var4, var1, 0);
        if (var5 instanceof ProtoChunk) {
            ProtoChunk var8 = (ProtoChunk)var5;
            Blender.addAroundOldChunksCarvingMaskFilter(var7, var8);
        }
        var0.generator().applyCarvers(var7, var6.getSeed(), var6.getChunkSource().randomState(), var6.getBiomeManager(), var6.structureManager().forWorldGenRegion(var7), var5, WorldGenStage.Features.AIR);
        return CompletableFuture.completedFuture(var5);
    }

    static CompletableFuture<IChunkAccess> generateFeatures(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        WorldServer var6 = var0.level();
        HeightMap.primeHeightmaps(var5, EnumSet.of(HeightMap.Type.MOTION_BLOCKING, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, HeightMap.Type.OCEAN_FLOOR, HeightMap.Type.WORLD_SURFACE));
        RegionLimitedWorldAccess var7 = new RegionLimitedWorldAccess(var6, var4, var1, 1);
        var0.generator().applyBiomeDecoration(var7, var5, var6.structureManager().forWorldGenRegion(var7));
        Blender.generateBorderTicks(var7, var5);
        return CompletableFuture.completedFuture(var5);
    }

    static CompletableFuture<IChunkAccess> generateInitializeLight(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        return ChunkStatusTasks.initializeLight(var0.lightEngine(), var5);
    }

    static CompletableFuture<IChunkAccess> loadInitializeLight(WorldGenContext var0, ChunkStatus var1, ToFullChunk var2, IChunkAccess var3) {
        return ChunkStatusTasks.initializeLight(var0.lightEngine(), var3);
    }

    private static CompletableFuture<IChunkAccess> initializeLight(LightEngineThreaded var0, IChunkAccess var1) {
        var1.initializeLightSources();
        ((ProtoChunk)var1).setLightEngine(var0);
        boolean var2 = ChunkStatusTasks.isLighted(var1);
        return var0.initializeLight(var1, var2);
    }

    static CompletableFuture<IChunkAccess> generateLight(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        return ChunkStatusTasks.lightChunk(var0.lightEngine(), var5);
    }

    static CompletableFuture<IChunkAccess> loadLight(WorldGenContext var0, ChunkStatus var1, ToFullChunk var2, IChunkAccess var3) {
        return ChunkStatusTasks.lightChunk(var0.lightEngine(), var3);
    }

    private static CompletableFuture<IChunkAccess> lightChunk(LightEngineThreaded var0, IChunkAccess var1) {
        boolean var2 = ChunkStatusTasks.isLighted(var1);
        return var0.lightChunk(var1, var2);
    }

    static CompletableFuture<IChunkAccess> generateSpawn(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        if (!var5.isUpgrading()) {
            var0.generator().spawnOriginalMobs(new RegionLimitedWorldAccess(var0.level(), var4, var1, -1));
        }
        return CompletableFuture.completedFuture(var5);
    }

    static CompletableFuture<IChunkAccess> generateFull(WorldGenContext var0, ChunkStatus var1, Executor var2, ToFullChunk var3, List<IChunkAccess> var4, IChunkAccess var5) {
        return var3.apply(var5);
    }

    static CompletableFuture<IChunkAccess> loadFull(WorldGenContext var0, ChunkStatus var1, ToFullChunk var2, IChunkAccess var3) {
        return var2.apply(var3);
    }
}

