/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class BrushableBlock
extends BlockTileEntity
implements Fallable {
    public static final MapCodec<BrushableBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("turns_into").forGetter(BrushableBlock::getTurnsInto), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("brush_sound").forGetter(BrushableBlock::getBrushSound), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("brush_comleted_sound").forGetter(BrushableBlock::getBrushCompletedSound), BrushableBlock.propertiesCodec()).apply((Applicative)var0, BrushableBlock::new));
    private static final BlockStateInteger DUSTED = BlockProperties.DUSTED;
    public static final int TICK_DELAY = 2;
    private final Block turnsInto;
    private final SoundEffect brushSound;
    private final SoundEffect brushCompletedSound;

    public MapCodec<BrushableBlock> codec() {
        return CODEC;
    }

    public BrushableBlock(Block var0, SoundEffect var1, SoundEffect var2, BlockBase.Info var3) {
        super(var3);
        this.turnsInto = var0;
        this.brushSound = var1;
        this.brushCompletedSound = var2;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(DUSTED, 0));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(DUSTED);
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        var1.scheduleTick(var2, this, 2);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        var3.scheduleTick(var4, this, 2);
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        Object var4;
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof BrushableBlockEntity) {
            var4 = (BrushableBlockEntity)tileEntity;
            ((BrushableBlockEntity)var4).checkReset();
        }
        if (!BlockFalling.isFree(var1.getBlockState(var2.below())) || var2.getY() < var1.getMinBuildHeight()) {
            return;
        }
        var4 = EntityFallingBlock.fall(var1, var2, var0);
        ((EntityFallingBlock)var4).disableDrop();
    }

    @Override
    public void onBrokenAfterFall(World var0, BlockPosition var1, EntityFallingBlock var2) {
        Vec3D var3 = var2.getBoundingBox().getCenter();
        var0.levelEvent(2001, BlockPosition.containing(var3), Block.getId(var2.getBlockState()));
        var0.gameEvent((Entity)var2, GameEvent.BLOCK_DESTROY, var3);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        BlockPosition var4;
        if (var3.nextInt(16) == 0 && BlockFalling.isFree(var1.getBlockState(var4 = var2.below()))) {
            double var5 = (double)var2.getX() + var3.nextDouble();
            double var7 = (double)var2.getY() - 0.05;
            double var9 = (double)var2.getZ() + var3.nextDouble();
            var1.addParticle(new ParticleParamBlock(Particles.FALLING_DUST, var0), var5, var7, var9, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new BrushableBlockEntity(var0, var1);
    }

    public Block getTurnsInto() {
        return this.turnsInto;
    }

    public SoundEffect getBrushSound() {
        return this.brushSound;
    }

    public SoundEffect getBrushCompletedSound() {
        return this.brushCompletedSound;
    }
}

