/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockShulkerBox
extends BlockTileEntity {
    public static final MapCodec<BlockShulkerBox> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)EnumColor.CODEC.optionalFieldOf("color").forGetter(var0 -> Optional.ofNullable(var0.color)), BlockShulkerBox.propertiesCodec()).apply((Applicative)var02, (var0, var1) -> new BlockShulkerBox(var0.orElse(null), (BlockBase.Info)var1)));
    private static final IChatBaseComponent UNKNOWN_CONTENTS = IChatBaseComponent.translatable("container.shulkerBox.unknownContents");
    private static final float OPEN_AABB_SIZE = 1.0f;
    private static final VoxelShape UP_OPEN_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape DOWN_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape WES_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_OPEN_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_OPEN_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> OPEN_SHAPE_BY_DIRECTION = SystemUtils.make(Maps.newEnumMap(EnumDirection.class), var0 -> {
        var0.put(EnumDirection.NORTH, NORTH_OPEN_AABB);
        var0.put(EnumDirection.EAST, EAST_OPEN_AABB);
        var0.put(EnumDirection.SOUTH, SOUTH_OPEN_AABB);
        var0.put(EnumDirection.WEST, WES_OPEN_AABB);
        var0.put(EnumDirection.UP, UP_OPEN_AABB);
        var0.put(EnumDirection.DOWN, DOWN_OPEN_AABB);
    });
    public static final BlockStateEnum<EnumDirection> FACING = BlockDirectional.FACING;
    public static final MinecraftKey CONTENTS = new MinecraftKey("contents");
    @Nullable
    public final EnumColor color;

    public MapCodec<BlockShulkerBox> codec() {
        return CODEC;
    }

    public BlockShulkerBox(@Nullable EnumColor var0, BlockBase.Info var1) {
        super(var1);
        this.color = var0;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.UP));
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityShulkerBox(this.color, var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockShulkerBox.createTickerHelper(var2, TileEntityTypes.SHULKER_BOX, TileEntityShulkerBox::tick);
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        if (var3.isSpectator()) {
            return EnumInteractionResult.CONSUME;
        }
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox var6 = (TileEntityShulkerBox)var5;
            if (BlockShulkerBox.canOpen(var0, var1, var2, var6)) {
                var3.openMenu(var6);
                var3.awardStat(StatisticList.OPEN_SHULKER_BOX);
                PiglinAI.angerNearbyPiglins(var3, true);
            }
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.PASS;
    }

    private static boolean canOpen(IBlockData var0, World var1, BlockPosition var2, TileEntityShulkerBox var3) {
        if (var3.getAnimationStatus() != TileEntityShulkerBox.AnimationPhase.CLOSED) {
            return true;
        }
        AxisAlignedBB var4 = EntityShulker.getProgressDeltaAabb(1.0f, var0.getValue(FACING), 0.0f, 0.5f).move(var2).deflate(1.0E-6);
        return var1.noCollision(var4);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getClickedFace());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING);
    }

    @Override
    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        TileEntity var4 = var0.getBlockEntity(var1);
        if (var4 instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox var5 = (TileEntityShulkerBox)var4;
            if (!var0.isClientSide && var3.isCreative() && !var5.isEmpty()) {
                ItemStack var6 = BlockShulkerBox.getColoredItemStack(this.getColor());
                var6.applyComponents(var4.collectComponents());
                EntityItem var7 = new EntityItem(var0, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, var6);
                var7.setDefaultPickUpDelay();
                var0.addFreshEntity(var7);
            } else {
                var5.unpackLootTable(var3);
            }
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    protected List<ItemStack> getDrops(IBlockData var0, LootParams.a var12) {
        TileEntity var2 = var12.getOptionalParameter(LootContextParameters.BLOCK_ENTITY);
        if (var2 instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox var3 = (TileEntityShulkerBox)var2;
            var12 = var12.withDynamicDrop(CONTENTS, var1 -> {
                for (int var2 = 0; var2 < var3.getContainerSize(); ++var2) {
                    var1.accept(var3.getItem(var2));
                }
            });
        }
        return super.getDrops(var0, var12);
    }

    @Override
    protected void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityShulkerBox) {
            var1.updateNeighbourForOutputSignal(var2, var0.getBlock());
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        if (var0.has(DataComponents.CONTAINER_LOOT)) {
            var2.add(UNKNOWN_CONTENTS);
        }
        int var4 = 0;
        int var5 = 0;
        for (ItemStack var7 : var0.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).nonEmptyItems()) {
            ++var5;
            if (var4 > 4) continue;
            ++var4;
            var2.add(IChatBaseComponent.translatable("container.shulkerBox.itemCount", var7.getHoverName(), var7.getCount()));
        }
        if (var5 - var4 > 0) {
            var2.add(IChatBaseComponent.translatable("container.shulkerBox.more", var5 - var4).withStyle(EnumChatFormat.ITALIC));
        }
    }

    @Override
    protected VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        TileEntityShulkerBox var4;
        TileEntity var3 = var1.getBlockEntity(var2);
        if (var3 instanceof TileEntityShulkerBox && !(var4 = (TileEntityShulkerBox)var3).isClosed()) {
            return OPEN_SHAPE_BY_DIRECTION.get(var0.getValue(FACING).getOpposite());
        }
        return VoxelShapes.block();
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TileEntityShulkerBox) {
            return VoxelShapes.create(((TileEntityShulkerBox)var4).getBoundingBox(var0));
        }
        return VoxelShapes.block();
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return false;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return Container.getRedstoneSignalFromBlockEntity(var1.getBlockEntity(var2));
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var22) {
        ItemStack var3 = super.getCloneItemStack(var0, var1, var22);
        var0.getBlockEntity(var1, TileEntityTypes.SHULKER_BOX).ifPresent(var2 -> var2.saveToItem(var3, var0.registryAccess()));
        return var3;
    }

    @Nullable
    public static EnumColor getColorFromItem(Item var0) {
        return BlockShulkerBox.getColorFromBlock(Block.byItem(var0));
    }

    @Nullable
    public static EnumColor getColorFromBlock(Block var0) {
        if (var0 instanceof BlockShulkerBox) {
            return ((BlockShulkerBox)var0).getColor();
        }
        return null;
    }

    public static Block getBlockByColor(@Nullable EnumColor var0) {
        if (var0 == null) {
            return Blocks.SHULKER_BOX;
        }
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumColor.WHITE -> Blocks.WHITE_SHULKER_BOX;
            case EnumColor.ORANGE -> Blocks.ORANGE_SHULKER_BOX;
            case EnumColor.MAGENTA -> Blocks.MAGENTA_SHULKER_BOX;
            case EnumColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_SHULKER_BOX;
            case EnumColor.YELLOW -> Blocks.YELLOW_SHULKER_BOX;
            case EnumColor.LIME -> Blocks.LIME_SHULKER_BOX;
            case EnumColor.PINK -> Blocks.PINK_SHULKER_BOX;
            case EnumColor.GRAY -> Blocks.GRAY_SHULKER_BOX;
            case EnumColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_SHULKER_BOX;
            case EnumColor.CYAN -> Blocks.CYAN_SHULKER_BOX;
            case EnumColor.BLUE -> Blocks.BLUE_SHULKER_BOX;
            case EnumColor.BROWN -> Blocks.BROWN_SHULKER_BOX;
            case EnumColor.GREEN -> Blocks.GREEN_SHULKER_BOX;
            case EnumColor.RED -> Blocks.RED_SHULKER_BOX;
            case EnumColor.BLACK -> Blocks.BLACK_SHULKER_BOX;
            case EnumColor.PURPLE -> Blocks.PURPLE_SHULKER_BOX;
        };
    }

    @Nullable
    public EnumColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable EnumColor var0) {
        return new ItemStack(BlockShulkerBox.getBlockByColor(var0));
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }
}

