/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockPortal
extends Block {
    public static final MapCodec<BlockPortal> CODEC = BlockPortal.simpleCodec(BlockPortal::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> AXIS = BlockProperties.HORIZONTAL_AXIS;
    protected static final int AABB_OFFSET = 2;
    protected static final VoxelShape X_AXIS_AABB = Block.box(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);

    public MapCodec<BlockPortal> codec() {
        return CODEC;
    }

    public BlockPortal(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AXIS, EnumDirection.EnumAxis.X));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch (var0.getValue(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var1.dimensionType().natural() && var1.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && var3.nextInt(2000) < var1.getDifficulty().getId()) {
            EntityPigZombie var4;
            while (var1.getBlockState(var2).is(this)) {
                var2 = var2.below();
            }
            if (var1.getBlockState(var2).isValidSpawn(var1, var2, EntityTypes.ZOMBIFIED_PIGLIN) && (var4 = EntityTypes.ZOMBIFIED_PIGLIN.spawn(var1, var2.above(), EnumMobSpawn.STRUCTURE)) != null) {
                var4.setPortalCooldown();
            }
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        boolean var8;
        EnumDirection.EnumAxis var6 = var1.getAxis();
        EnumDirection.EnumAxis var7 = var0.getValue(AXIS);
        boolean bl = var8 = var7 != var6 && var6.isHorizontal();
        if (var8 || var2.is(this) || new BlockPortalShape(var3, var4, var7).isComplete()) {
            return super.updateShape(var0, var1, var2, var3, var4, var5);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var3.canChangeDimensions()) {
            var3.handleInsidePortal(var2);
        }
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (var3.nextInt(100) == 0) {
            var1.playLocalSound((double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, SoundEffects.PORTAL_AMBIENT, SoundCategory.BLOCKS, 0.5f, var3.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int var4 = 0; var4 < 4; ++var4) {
            double var5 = (double)var2.getX() + var3.nextDouble();
            double var7 = (double)var2.getY() + var3.nextDouble();
            double var9 = (double)var2.getZ() + var3.nextDouble();
            double var11 = ((double)var3.nextFloat() - 0.5) * 0.5;
            double var13 = ((double)var3.nextFloat() - 0.5) * 0.5;
            double var15 = ((double)var3.nextFloat() - 0.5) * 0.5;
            int var17 = var3.nextInt(2) * 2 - 1;
            if (var1.getBlockState(var2.west()).is(this) || var1.getBlockState(var2.east()).is(this)) {
                var9 = (double)var2.getZ() + 0.5 + 0.25 * (double)var17;
                var15 = var3.nextFloat() * 2.0f * (float)var17;
            } else {
                var5 = (double)var2.getX() + 0.5 + 0.25 * (double)var17;
                var11 = var3.nextFloat() * 2.0f * (float)var17;
            }
            var1.addParticle(Particles.PORTAL, var5, var7, var9, var11, var13, var15);
        }
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return ItemStack.EMPTY;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (var0.getValue(AXIS)) {
                    case X: {
                        return (IBlockData)var0.setValue(AXIS, EnumDirection.EnumAxis.Z);
                    }
                    case Z: {
                        return (IBlockData)var0.setValue(AXIS, EnumDirection.EnumAxis.X);
                    }
                }
                return var0;
            }
        }
        return var0;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AXIS);
    }
}

