/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockConcretePowder
extends BlockFalling {
    public static final MapCodec<BlockConcretePowder> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("concrete").forGetter(var0 -> var0.concrete), BlockConcretePowder.propertiesCodec()).apply((Applicative)var02, BlockConcretePowder::new));
    private final Block concrete;

    public MapCodec<BlockConcretePowder> codec() {
        return CODEC;
    }

    public BlockConcretePowder(Block var0, BlockBase.Info var1) {
        super(var1);
        this.concrete = var0;
    }

    @Override
    public void onLand(World var0, BlockPosition var1, IBlockData var2, IBlockData var3, EntityFallingBlock var4) {
        if (BlockConcretePowder.shouldSolidify(var0, var1, var3)) {
            var0.setBlock(var1, this.concrete.defaultBlockState(), 3);
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var3;
        BlockPosition var2;
        World var1 = var0.getLevel();
        if (BlockConcretePowder.shouldSolidify(var1, var2 = var0.getClickedPos(), var3 = var1.getBlockState(var2))) {
            return this.concrete.defaultBlockState();
        }
        return super.getStateForPlacement(var0);
    }

    private static boolean shouldSolidify(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return BlockConcretePowder.canSolidify(var2) || BlockConcretePowder.touchesLiquid(var0, var1);
    }

    private static boolean touchesLiquid(IBlockAccess var0, BlockPosition var1) {
        boolean var2 = false;
        BlockPosition.MutableBlockPosition var3 = var1.mutable();
        for (EnumDirection var7 : EnumDirection.values()) {
            IBlockData var8 = var0.getBlockState(var3);
            if (var7 == EnumDirection.DOWN && !BlockConcretePowder.canSolidify(var8)) continue;
            var3.setWithOffset((BaseBlockPosition)var1, var7);
            var8 = var0.getBlockState(var3);
            if (!BlockConcretePowder.canSolidify(var8) || var8.isFaceSturdy(var0, var1, var7.getOpposite())) continue;
            var2 = true;
            break;
        }
        return var2;
    }

    private static boolean canSolidify(IBlockData var0) {
        return var0.getFluidState().is(TagsFluid.WATER);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (BlockConcretePowder.touchesLiquid(var3, var4)) {
            return this.concrete.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public int getDustColor(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.getMapColor((IBlockAccess)var1, (BlockPosition)var2).col;
    }
}

