/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.World;

public class WindBurstEnchantment
extends Enchantment {
    public WindBurstEnchantment() {
        super(Enchantment.definition(TagsItem.MACE_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, FeatureFlagSet.of(FeatureFlags.UPDATE_1_21), EnumItemSlot.MAINHAND));
    }

    @Override
    public void doPostItemStackHurt(EntityLiving var0, Entity var1, int var2) {
        float var3 = 0.25f + 0.25f * (float)var2;
        var0.level().explode(null, null, new a(var3), var0.getX(), var0.getY(), var0.getZ(), 3.5f, false, World.a.BLOW, Particles.GUST_EMITTER_SMALL, Particles.GUST_EMITTER_LARGE, SoundEffects.WIND_CHARGE_BURST);
    }

    @Override
    public boolean isTradeable() {
        return false;
    }

    @Override
    public boolean isDiscoverable() {
        return false;
    }

    static final class a
    extends AbstractWindCharge.a {
        private final float knockBackPower;

        public a(float var0) {
            this.knockBackPower = var0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public float getKnockbackMultiplier(Entity var0) {
            if (var0 instanceof EntityHuman) {
                EntityHuman var2 = (EntityHuman)var0;
                if (var2.getAbilities().flying) {
                    return 0.0f;
                }
            }
            boolean bl = false;
            boolean var1 = bl;
            if (var1) return 0.0f;
            float f2 = this.knockBackPower;
            return f2;
        }
    }
}

