/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;

public class ItemEnchantments
implements TooltipProvider {
    public static final ItemEnchantments EMPTY = new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap(), true);
    public static final int MAX_LEVEL = 255;
    private static final Codec<Integer> LEVEL_CODEC = Codec.intRange((int)0, (int)255);
    private static final Codec<Object2IntOpenHashMap<Holder<Enchantment>>> LEVELS_CODEC = Codec.unboundedMap(BuiltInRegistries.ENCHANTMENT.holderByNameCodec(), LEVEL_CODEC).xmap(Object2IntOpenHashMap::new, Function.identity());
    private static final Codec<ItemEnchantments> FULL_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)LEVELS_CODEC.fieldOf("levels").forGetter(var0 -> var0.enchantments), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(var0 -> var0.showInTooltip)).apply((Applicative)var02, ItemEnchantments::new));
    public static final Codec<ItemEnchantments> CODEC = Codec.withAlternative(FULL_CODEC, LEVELS_CODEC, var0 -> new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)var0, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantments> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.map(Object2IntOpenHashMap::new, ByteBufCodecs.holderRegistry(Registries.ENCHANTMENT), ByteBufCodecs.VAR_INT), var0 -> var0.enchantments, ByteBufCodecs.BOOL, var0 -> var0.showInTooltip, ItemEnchantments::new);
    final Object2IntOpenHashMap<Holder<Enchantment>> enchantments;
    public final boolean showInTooltip;

    ItemEnchantments(Object2IntOpenHashMap<Holder<Enchantment>> var0, boolean var1) {
        this.enchantments = var0;
        this.showInTooltip = var1;
        for (Object2IntMap.Entry var3 : var0.object2IntEntrySet()) {
            int var4 = var3.getIntValue();
            if (var4 >= 0 && var4 <= 255) continue;
            throw new IllegalArgumentException("Enchantment " + String.valueOf(var3.getKey()) + " has invalid level " + var4);
        }
    }

    public int getLevel(Enchantment var0) {
        return this.enchantments.getInt(var0.builtInRegistryHolder());
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2) {
        if (!this.showInTooltip) {
            return;
        }
        HolderLookup.a var3 = var0.registries();
        HolderSet<Enchantment> var4 = ItemEnchantments.getTagOrEmpty(var3, Registries.ENCHANTMENT, EnchantmentTags.TOOLTIP_ORDER);
        for (Holder holder : var4) {
            int var7 = this.enchantments.getInt((Object)holder);
            if (var7 <= 0) continue;
            var1.accept(((Enchantment)holder.value()).getFullname(var7));
        }
        for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
            Holder var7 = (Holder)entry.getKey();
            if (var4.contains(var7)) continue;
            var1.accept(((Enchantment)var7.value()).getFullname(entry.getIntValue()));
        }
    }

    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.a var0, ResourceKey<IRegistry<T>> var1, TagKey<T> var2) {
        Optional<HolderSet.Named<T>> var3;
        if (var0 != null && (var3 = var0.lookupOrThrow(var1).get(var2)).isPresent()) {
            return var3.get();
        }
        return HolderSet.direct(new Holder[0]);
    }

    public ItemEnchantments withTooltip(boolean var0) {
        return new ItemEnchantments(this.enchantments, var0);
    }

    public Set<Holder<Enchantment>> keySet() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<Enchantment>>> entrySet() {
        return Collections.unmodifiableSet(this.enchantments.object2IntEntrySet());
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ItemEnchantments) {
            ItemEnchantments var1 = (ItemEnchantments)var0;
            return this.showInTooltip == var1.showInTooltip && this.enchantments.equals(var1.enchantments);
        }
        return false;
    }

    public int hashCode() {
        int var0 = this.enchantments.hashCode();
        var0 = 31 * var0 + (this.showInTooltip ? 1 : 0);
        return var0;
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + String.valueOf(this.enchantments) + ", showInTooltip=" + this.showInTooltip + "}";
    }

    public static class a {
        private final Object2IntOpenHashMap<Holder<Enchantment>> enchantments = new Object2IntOpenHashMap();
        public boolean showInTooltip;

        public a(ItemEnchantments var0) {
            this.enchantments.putAll(var0.enchantments);
            this.showInTooltip = var0.showInTooltip;
        }

        public void set(Enchantment var0, int var1) {
            if (var1 <= 0) {
                this.enchantments.removeInt(var0.builtInRegistryHolder());
            } else {
                this.enchantments.put(var0.builtInRegistryHolder(), Math.min(var1, 255));
            }
        }

        public void upgrade(Enchantment var0, int var1) {
            if (var1 > 0) {
                this.enchantments.merge(var0.builtInRegistryHolder(), Math.min(var1, 255), Integer::max);
            }
        }

        public void removeIf(Predicate<Holder<Enchantment>> var0) {
            this.enchantments.keySet().removeIf(var0);
        }

        public int getLevel(Enchantment var0) {
            return this.enchantments.getOrDefault(var0.builtInRegistryHolder(), 0);
        }

        public Set<Holder<Enchantment>> keySet() {
            return this.enchantments.keySet();
        }

        public ItemEnchantments toImmutable() {
            return new ItemEnchantments(this.enchantments, this.showInTooltip);
        }
    }
}

