/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.Optional;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.enchantment.BreachEnchantment;
import net.minecraft.world.item.enchantment.DensityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentBinding;
import net.minecraft.world.item.enchantment.EnchantmentDepthStrider;
import net.minecraft.world.item.enchantment.EnchantmentDurability;
import net.minecraft.world.item.enchantment.EnchantmentFrostWalker;
import net.minecraft.world.item.enchantment.EnchantmentInfiniteArrows;
import net.minecraft.world.item.enchantment.EnchantmentLootBonus;
import net.minecraft.world.item.enchantment.EnchantmentMending;
import net.minecraft.world.item.enchantment.EnchantmentMultishot;
import net.minecraft.world.item.enchantment.EnchantmentPiercing;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.item.enchantment.EnchantmentSilkTouch;
import net.minecraft.world.item.enchantment.EnchantmentSoulSpeed;
import net.minecraft.world.item.enchantment.EnchantmentThorns;
import net.minecraft.world.item.enchantment.EnchantmentTridentRiptide;
import net.minecraft.world.item.enchantment.EnchantmentVanishing;
import net.minecraft.world.item.enchantment.EnchantmentWeaponDamage;
import net.minecraft.world.item.enchantment.SwiftSneakEnchantment;
import net.minecraft.world.item.enchantment.WindBurstEnchantment;

public class Enchantments {
    private static final EnumItemSlot[] ARMOR_SLOTS = new EnumItemSlot[]{EnumItemSlot.HEAD, EnumItemSlot.CHEST, EnumItemSlot.LEGS, EnumItemSlot.FEET};
    public static final Enchantment PROTECTION = Enchantments.register("protection", new EnchantmentProtection(Enchantment.definition(TagsItem.ARMOR_ENCHANTABLE, 10, 4, Enchantment.dynamicCost(1, 11), Enchantment.dynamicCost(12, 11), 1, ARMOR_SLOTS), EnchantmentProtection.DamageType.ALL));
    public static final Enchantment FIRE_PROTECTION = Enchantments.register("fire_protection", new EnchantmentProtection(Enchantment.definition(TagsItem.ARMOR_ENCHANTABLE, 5, 4, Enchantment.dynamicCost(10, 8), Enchantment.dynamicCost(18, 8), 2, ARMOR_SLOTS), EnchantmentProtection.DamageType.FIRE));
    public static final Enchantment FEATHER_FALLING = Enchantments.register("feather_falling", new EnchantmentProtection(Enchantment.definition(TagsItem.FOOT_ARMOR_ENCHANTABLE, 5, 4, Enchantment.dynamicCost(5, 6), Enchantment.dynamicCost(11, 6), 2, ARMOR_SLOTS), EnchantmentProtection.DamageType.FALL));
    public static final Enchantment BLAST_PROTECTION = Enchantments.register("blast_protection", new EnchantmentProtection(Enchantment.definition(TagsItem.ARMOR_ENCHANTABLE, 2, 4, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(13, 8), 4, ARMOR_SLOTS), EnchantmentProtection.DamageType.EXPLOSION));
    public static final Enchantment PROJECTILE_PROTECTION = Enchantments.register("projectile_protection", new EnchantmentProtection(Enchantment.definition(TagsItem.ARMOR_ENCHANTABLE, 5, 4, Enchantment.dynamicCost(3, 6), Enchantment.dynamicCost(9, 6), 2, ARMOR_SLOTS), EnchantmentProtection.DamageType.PROJECTILE));
    public static final Enchantment RESPIRATION = Enchantments.register("respiration", new Enchantment(Enchantment.definition(TagsItem.HEAD_ARMOR_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(40, 10), 4, ARMOR_SLOTS)));
    public static final Enchantment AQUA_AFFINITY = Enchantments.register("aqua_affinity", new Enchantment(Enchantment.definition(TagsItem.HEAD_ARMOR_ENCHANTABLE, 2, 1, Enchantment.constantCost(1), Enchantment.constantCost(41), 4, ARMOR_SLOTS)));
    public static final Enchantment THORNS = Enchantments.register("thorns", new EnchantmentThorns(Enchantment.definition(TagsItem.ARMOR_ENCHANTABLE, TagsItem.CHEST_ARMOR_ENCHANTABLE, 1, 3, Enchantment.dynamicCost(10, 20), Enchantment.dynamicCost(60, 20), 8, ARMOR_SLOTS)));
    public static final Enchantment DEPTH_STRIDER = Enchantments.register("depth_strider", new EnchantmentDepthStrider(Enchantment.definition(TagsItem.FOOT_ARMOR_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(25, 10), 4, ARMOR_SLOTS)));
    public static final Enchantment FROST_WALKER = Enchantments.register("frost_walker", new EnchantmentFrostWalker(Enchantment.definition(TagsItem.FOOT_ARMOR_ENCHANTABLE, 2, 2, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(25, 10), 4, EnumItemSlot.FEET)));
    public static final Enchantment BINDING_CURSE = Enchantments.register("binding_curse", new EnchantmentBinding(Enchantment.definition(TagsItem.EQUIPPABLE_ENCHANTABLE, 1, 1, Enchantment.constantCost(25), Enchantment.constantCost(50), 8, ARMOR_SLOTS)));
    public static final Enchantment SOUL_SPEED = Enchantments.register("soul_speed", new EnchantmentSoulSpeed(Enchantment.definition(TagsItem.FOOT_ARMOR_ENCHANTABLE, 1, 3, Enchantment.dynamicCost(10, 10), Enchantment.dynamicCost(25, 10), 8, EnumItemSlot.FEET)));
    public static final Enchantment SWIFT_SNEAK = Enchantments.register("swift_sneak", new SwiftSneakEnchantment(Enchantment.definition(TagsItem.LEG_ARMOR_ENCHANTABLE, 1, 3, Enchantment.dynamicCost(25, 25), Enchantment.dynamicCost(75, 25), 8, EnumItemSlot.LEGS)));
    public static final Enchantment SHARPNESS = Enchantments.register("sharpness", new EnchantmentWeaponDamage(Enchantment.definition(TagsItem.SHARP_WEAPON_ENCHANTABLE, TagsItem.SWORD_ENCHANTABLE, 10, 5, Enchantment.dynamicCost(1, 11), Enchantment.dynamicCost(21, 11), 1, EnumItemSlot.MAINHAND), Optional.empty()));
    public static final Enchantment SMITE = Enchantments.register("smite", new EnchantmentWeaponDamage(Enchantment.definition(TagsItem.WEAPON_ENCHANTABLE, TagsItem.SWORD_ENCHANTABLE, 5, 5, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(25, 8), 2, EnumItemSlot.MAINHAND), Optional.of(TagsEntity.SENSITIVE_TO_SMITE)));
    public static final Enchantment BANE_OF_ARTHROPODS = Enchantments.register("bane_of_arthropods", new EnchantmentWeaponDamage(Enchantment.definition(TagsItem.WEAPON_ENCHANTABLE, TagsItem.SWORD_ENCHANTABLE, 5, 5, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(25, 8), 2, EnumItemSlot.MAINHAND), Optional.of(TagsEntity.SENSITIVE_TO_BANE_OF_ARTHROPODS)));
    public static final Enchantment KNOCKBACK = Enchantments.register("knockback", new Enchantment(Enchantment.definition(TagsItem.SWORD_ENCHANTABLE, 5, 2, Enchantment.dynamicCost(5, 20), Enchantment.dynamicCost(55, 20), 2, EnumItemSlot.MAINHAND)));
    public static final Enchantment FIRE_ASPECT = Enchantments.register("fire_aspect", new Enchantment(Enchantment.definition(TagsItem.FIRE_ASPECT_ENCHANTABLE, 2, 2, Enchantment.dynamicCost(10, 20), Enchantment.dynamicCost(60, 20), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment LOOTING = Enchantments.register("looting", new EnchantmentLootBonus(Enchantment.definition(TagsItem.SWORD_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment SWEEPING_EDGE = Enchantments.register("sweeping_edge", new Enchantment(Enchantment.definition(TagsItem.SWORD_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(5, 9), Enchantment.dynamicCost(20, 9), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment EFFICIENCY = Enchantments.register("efficiency", new Enchantment(Enchantment.definition(TagsItem.MINING_ENCHANTABLE, 10, 5, Enchantment.dynamicCost(1, 10), Enchantment.dynamicCost(51, 10), 1, EnumItemSlot.MAINHAND)));
    public static final Enchantment SILK_TOUCH = Enchantments.register("silk_touch", new EnchantmentSilkTouch(Enchantment.definition(TagsItem.MINING_LOOT_ENCHANTABLE, 1, 1, Enchantment.constantCost(15), Enchantment.constantCost(65), 8, EnumItemSlot.MAINHAND)));
    public static final Enchantment UNBREAKING = Enchantments.register("unbreaking", new EnchantmentDurability(Enchantment.definition(TagsItem.DURABILITY_ENCHANTABLE, 5, 3, Enchantment.dynamicCost(5, 8), Enchantment.dynamicCost(55, 8), 2, EnumItemSlot.MAINHAND)));
    public static final Enchantment FORTUNE = Enchantments.register("fortune", new EnchantmentLootBonus(Enchantment.definition(TagsItem.MINING_LOOT_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment POWER = Enchantments.register("power", new Enchantment(Enchantment.definition(TagsItem.BOW_ENCHANTABLE, 10, 5, Enchantment.dynamicCost(1, 10), Enchantment.dynamicCost(16, 10), 1, EnumItemSlot.MAINHAND)));
    public static final Enchantment PUNCH = Enchantments.register("punch", new Enchantment(Enchantment.definition(TagsItem.BOW_ENCHANTABLE, 2, 2, Enchantment.dynamicCost(12, 20), Enchantment.dynamicCost(37, 20), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment FLAME = Enchantments.register("flame", new Enchantment(Enchantment.definition(TagsItem.BOW_ENCHANTABLE, 2, 1, Enchantment.constantCost(20), Enchantment.constantCost(50), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment INFINITY = Enchantments.register("infinity", new EnchantmentInfiniteArrows(Enchantment.definition(TagsItem.BOW_ENCHANTABLE, 1, 1, Enchantment.constantCost(20), Enchantment.constantCost(50), 8, EnumItemSlot.MAINHAND)));
    public static final Enchantment LUCK_OF_THE_SEA = Enchantments.register("luck_of_the_sea", new EnchantmentLootBonus(Enchantment.definition(TagsItem.FISHING_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment LURE = Enchantments.register("lure", new Enchantment(Enchantment.definition(TagsItem.FISHING_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment LOYALTY = Enchantments.register("loyalty", new Enchantment(Enchantment.definition(TagsItem.TRIDENT_ENCHANTABLE, 5, 3, Enchantment.dynamicCost(12, 7), Enchantment.constantCost(50), 2, EnumItemSlot.MAINHAND)));
    public static final Enchantment IMPALING = Enchantments.register("impaling", new EnchantmentWeaponDamage(Enchantment.definition(TagsItem.TRIDENT_ENCHANTABLE, 2, 5, Enchantment.dynamicCost(1, 8), Enchantment.dynamicCost(21, 8), 4, EnumItemSlot.MAINHAND), Optional.of(TagsEntity.SENSITIVE_TO_IMPALING)));
    public static final Enchantment RIPTIDE = Enchantments.register("riptide", new EnchantmentTridentRiptide(Enchantment.definition(TagsItem.TRIDENT_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(17, 7), Enchantment.constantCost(50), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment CHANNELING = Enchantments.register("channeling", new Enchantment(Enchantment.definition(TagsItem.TRIDENT_ENCHANTABLE, 1, 1, Enchantment.constantCost(25), Enchantment.constantCost(50), 8, EnumItemSlot.MAINHAND)));
    public static final Enchantment MULTISHOT = Enchantments.register("multishot", new EnchantmentMultishot(Enchantment.definition(TagsItem.CROSSBOW_ENCHANTABLE, 2, 1, Enchantment.constantCost(20), Enchantment.constantCost(50), 4, EnumItemSlot.MAINHAND)));
    public static final Enchantment QUICK_CHARGE = Enchantments.register("quick_charge", new Enchantment(Enchantment.definition(TagsItem.CROSSBOW_ENCHANTABLE, 5, 3, Enchantment.dynamicCost(12, 20), Enchantment.constantCost(50), 2, EnumItemSlot.MAINHAND)));
    public static final Enchantment PIERCING = Enchantments.register("piercing", new EnchantmentPiercing(Enchantment.definition(TagsItem.CROSSBOW_ENCHANTABLE, 10, 4, Enchantment.dynamicCost(1, 10), Enchantment.constantCost(50), 1, EnumItemSlot.MAINHAND)));
    public static final Enchantment DENSITY = Enchantments.register("density", new DensityEnchantment());
    public static final Enchantment BREACH = Enchantments.register("breach", new BreachEnchantment());
    public static final Enchantment WIND_BURST = Enchantments.register("wind_burst", new WindBurstEnchantment());
    public static final Enchantment MENDING = Enchantments.register("mending", new EnchantmentMending(Enchantment.definition(TagsItem.DURABILITY_ENCHANTABLE, 2, 1, Enchantment.dynamicCost(25, 25), Enchantment.dynamicCost(75, 25), 4, EnumItemSlot.values())));
    public static final Enchantment VANISHING_CURSE = Enchantments.register("vanishing_curse", new EnchantmentVanishing(Enchantment.definition(TagsItem.VANISHING_ENCHANTABLE, 1, 1, Enchantment.constantCost(25), Enchantment.constantCost(50), 8, EnumItemSlot.values())));

    private static Enchantment register(String var0, Enchantment var1) {
        return IRegistry.register(BuiltInRegistries.ENCHANTMENT, var0, var1);
    }
}

