/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentWeaponDamage
extends Enchantment {
    private final Optional<TagKey<EntityTypes<?>>> targets;

    public EnchantmentWeaponDamage(Enchantment.b var0, Optional<TagKey<EntityTypes<?>>> var1) {
        super(var0);
        this.targets = var1;
    }

    @Override
    public float getDamageBonus(int var0, @Nullable EntityTypes<?> var1) {
        if (this.targets.isEmpty()) {
            return 1.0f + (float)Math.max(0, var0 - 1) * 0.5f;
        }
        if (var1 != null && var1.is(this.targets.get())) {
            return (float)var0 * 2.5f;
        }
        return 0.0f;
    }

    @Override
    public boolean checkCompatibility(Enchantment var0) {
        return !(var0 instanceof EnchantmentWeaponDamage);
    }

    @Override
    public void doPostAttack(EntityLiving var0, Entity var1, int var2) {
        if (this.targets.isPresent() && var1 instanceof EntityLiving) {
            EntityLiving var3 = (EntityLiving)var1;
            if (this.targets.get() == TagsEntity.SENSITIVE_TO_BANE_OF_ARTHROPODS && var2 > 0 && var3.getType().is(this.targets.get())) {
                int var4 = 20 + var0.getRandom().nextInt(10 * var2);
                var3.addEffect(new MobEffect(MobEffects.MOVEMENT_SLOWDOWN, var4, 3));
            }
        }
    }
}

