/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;

public class EnchantmentProtection
extends Enchantment {
    public final DamageType type;

    public EnchantmentProtection(Enchantment.b var0, DamageType var1) {
        super(var0);
        this.type = var1;
    }

    @Override
    public int getDamageProtection(int var0, DamageSource var1) {
        if (var1.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return 0;
        }
        if (this.type == DamageType.ALL) {
            return var0;
        }
        if (this.type == DamageType.FIRE && var1.is(DamageTypeTags.IS_FIRE)) {
            return var0 * 2;
        }
        if (this.type == DamageType.FALL && var1.is(DamageTypeTags.IS_FALL)) {
            return var0 * 3;
        }
        if (this.type == DamageType.EXPLOSION && var1.is(DamageTypeTags.IS_EXPLOSION)) {
            return var0 * 2;
        }
        if (this.type == DamageType.PROJECTILE && var1.is(DamageTypeTags.IS_PROJECTILE)) {
            return var0 * 2;
        }
        return 0;
    }

    @Override
    public boolean checkCompatibility(Enchantment var0) {
        if (var0 instanceof EnchantmentProtection) {
            EnchantmentProtection var1 = (EnchantmentProtection)var0;
            if (this.type == var1.type) {
                return false;
            }
            return this.type == DamageType.FALL || var1.type == DamageType.FALL;
        }
        return super.checkCompatibility(var0);
    }

    public static int getFireAfterDampener(EntityLiving var0, int var1) {
        int var2 = EnchantmentManager.getEnchantmentLevel(Enchantments.FIRE_PROTECTION, var0);
        if (var2 > 0) {
            var1 -= MathHelper.floor((float)var1 * ((float)var2 * 0.15f));
        }
        return var1;
    }

    public static double getExplosionKnockbackAfterDampener(EntityLiving var0, double var1) {
        int var3 = EnchantmentManager.getEnchantmentLevel(Enchantments.BLAST_PROTECTION, var0);
        if (var3 > 0) {
            var1 *= MathHelper.clamp(1.0 - (double)var3 * 0.15, 0.0, 1.0);
        }
        return var1;
    }

    public static final class DamageType
    extends Enum<DamageType> {
        public static final /* enum */ DamageType ALL = new DamageType();
        public static final /* enum */ DamageType FIRE = new DamageType();
        public static final /* enum */ DamageType FALL = new DamageType();
        public static final /* enum */ DamageType EXPLOSION = new DamageType();
        public static final /* enum */ DamageType PROJECTILE = new DamageType();
        private static final /* synthetic */ DamageType[] f;

        public static DamageType[] values() {
            return (DamageType[])f.clone();
        }

        public static DamageType valueOf(String var0) {
            return Enum.valueOf(DamageType.class, var0);
        }

        private static /* synthetic */ DamageType[] a() {
            return new DamageType[]{ALL, FIRE, FALL, EXPLOSION, PROJECTILE};
        }

        static {
            f = DamageType.a();
        }
    }
}

