/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.World;

public class SmithingTrimRecipe
implements SmithingRecipe {
    final RecipeItemStack template;
    final RecipeItemStack base;
    final RecipeItemStack addition;

    public SmithingTrimRecipe(RecipeItemStack var0, RecipeItemStack var1, RecipeItemStack var2) {
        this.template = var0;
        this.base = var1;
        this.addition = var2;
    }

    @Override
    public boolean matches(IInventory var0, World var1) {
        return this.template.test(var0.getItem(0)) && this.base.test(var0.getItem(1)) && this.addition.test(var0.getItem(2));
    }

    @Override
    public ItemStack assemble(IInventory var0, HolderLookup.a var1) {
        ItemStack var2 = var0.getItem(1);
        if (this.base.test(var2)) {
            Optional<Holder.c<TrimMaterial>> var3 = TrimMaterials.getFromIngredient(var1, var0.getItem(2));
            Optional<Holder.c<TrimPattern>> var4 = TrimPatterns.getFromTemplate(var1, var0.getItem(0));
            if (var3.isPresent() && var4.isPresent()) {
                ArmorTrim var5 = var2.get(DataComponents.TRIM);
                if (var5 != null && var5.hasPatternAndMaterial((Holder<TrimPattern>)var4.get(), (Holder<TrimMaterial>)var3.get())) {
                    return ItemStack.EMPTY;
                }
                ItemStack var6 = var2.copyWithCount(1);
                var6.set(DataComponents.TRIM, new ArmorTrim((Holder<TrimMaterial>)var3.get(), (Holder<TrimPattern>)var4.get()));
                return var6;
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.a var0) {
        ItemStack var1 = new ItemStack(Items.IRON_CHESTPLATE);
        Optional var2 = var0.lookupOrThrow(Registries.TRIM_PATTERN).listElements().findFirst();
        Optional<Holder.c<TrimMaterial>> var3 = var0.lookupOrThrow(Registries.TRIM_MATERIAL).get(TrimMaterials.REDSTONE);
        if (var2.isPresent() && var3.isPresent()) {
            var1.set(DataComponents.TRIM, new ArmorTrim((Holder<TrimMaterial>)var3.get(), var2.get()));
        }
        return var1;
    }

    @Override
    public boolean isTemplateIngredient(ItemStack var0) {
        return this.template.test(var0);
    }

    @Override
    public boolean isBaseIngredient(ItemStack var0) {
        return this.base.test(var0);
    }

    @Override
    public boolean isAdditionIngredient(ItemStack var0) {
        return this.addition.test(var0);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRIM;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(RecipeItemStack::isEmpty);
    }

    public static class a
    implements RecipeSerializer<SmithingTrimRecipe> {
        private static final MapCodec<SmithingTrimRecipe> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)RecipeItemStack.CODEC.fieldOf("template").forGetter(var0 -> var0.template), (App)RecipeItemStack.CODEC.fieldOf("base").forGetter(var0 -> var0.base), (App)RecipeItemStack.CODEC.fieldOf("addition").forGetter(var0 -> var0.addition)).apply((Applicative)var02, SmithingTrimRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> STREAM_CODEC = StreamCodec.of(a::toNetwork, a::fromNetwork);

        @Override
        public MapCodec<SmithingTrimRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmithingTrimRecipe fromNetwork(RegistryFriendlyByteBuf var0) {
            RecipeItemStack var1 = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(var0);
            RecipeItemStack var2 = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(var0);
            RecipeItemStack var3 = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(var0);
            return new SmithingTrimRecipe(var1, var2, var3);
        }

        private static void toNetwork(RegistryFriendlyByteBuf var0, SmithingTrimRecipe var1) {
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(var0, var1.template);
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(var0, var1.base);
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(var0, var1.addition);
        }
    }
}

