/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;

public record ShapedRecipePattern(int width, int height, NonNullList<RecipeItemStack> ingredients, Optional<a> data) {
    private static final int MAX_SIZE = 3;
    public static final MapCodec<ShapedRecipePattern> MAP_CODEC = a.MAP_CODEC.flatXmap(ShapedRecipePattern::unpack, var0 -> var0.data().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipePattern> STREAM_CODEC = StreamCodec.ofMember(ShapedRecipePattern::toNetwork, ShapedRecipePattern::fromNetwork);

    public static ShapedRecipePattern of(Map<Character, RecipeItemStack> var0, String ... var1) {
        return ShapedRecipePattern.of(var0, List.of(var1));
    }

    public static ShapedRecipePattern of(Map<Character, RecipeItemStack> var0, List<String> var1) {
        a var2 = new a(var0, var1);
        return (ShapedRecipePattern)ShapedRecipePattern.unpack(var2).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> unpack(a var0) {
        String[] var1 = ShapedRecipePattern.shrink(var0.pattern);
        int var2 = var1[0].length();
        int var3 = var1.length;
        NonNullList<RecipeItemStack> var4 = NonNullList.withSize(var2 * var3, RecipeItemStack.EMPTY);
        CharArraySet var5 = new CharArraySet(var0.key.keySet());
        for (int var6 = 0; var6 < var1.length; ++var6) {
            String var7 = var1[var6];
            for (int var8 = 0; var8 < var7.length(); ++var8) {
                RecipeItemStack var10;
                char var9 = var7.charAt(var8);
                RecipeItemStack recipeItemStack = var10 = var9 == ' ' ? RecipeItemStack.EMPTY : var0.key.get(Character.valueOf(var9));
                if (var10 == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + var9 + "' but it's not defined in the key");
                }
                var5.remove(var9);
                var4.set(var8 + var2 * var6, var10);
            }
        }
        if (!var5.isEmpty()) {
            return DataResult.error(() -> ShapedRecipePattern.a((CharSet)var5));
        }
        return DataResult.success((Object)new ShapedRecipePattern(var2, var3, var4, Optional.of(var0)));
    }

    @VisibleForTesting
    static String[] shrink(List<String> var0) {
        int var1 = Integer.MAX_VALUE;
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;
        for (int var5 = 0; var5 < var0.size(); ++var5) {
            String var6 = var0.get(var5);
            var1 = Math.min(var1, ShapedRecipePattern.firstNonSpace(var6));
            int var7 = ShapedRecipePattern.lastNonSpace(var6);
            var2 = Math.max(var2, var7);
            if (var7 < 0) {
                if (var3 == var5) {
                    ++var3;
                }
                ++var4;
                continue;
            }
            var4 = 0;
        }
        if (var0.size() == var4) {
            return new String[0];
        }
        String[] var5 = new String[var0.size() - var4 - var3];
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = var0.get(var6 + var3).substring(var1, var2 + 1);
        }
        return var5;
    }

    private static int firstNonSpace(String var0) {
        int var1;
        for (var1 = 0; var1 < var0.length() && var0.charAt(var1) == ' '; ++var1) {
        }
        return var1;
    }

    private static int lastNonSpace(String var0) {
        int var1;
        for (var1 = var0.length() - 1; var1 >= 0 && var0.charAt(var1) == ' '; --var1) {
        }
        return var1;
    }

    public boolean matches(InventoryCrafting var0) {
        for (int var1 = 0; var1 <= var0.getWidth() - this.width; ++var1) {
            for (int var2 = 0; var2 <= var0.getHeight() - this.height; ++var2) {
                if (this.matches(var0, var1, var2, true)) {
                    return true;
                }
                if (!this.matches(var0, var1, var2, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(InventoryCrafting var0, int var1, int var2, boolean var3) {
        for (int var4 = 0; var4 < var0.getWidth(); ++var4) {
            for (int var5 = 0; var5 < var0.getHeight(); ++var5) {
                int var6 = var4 - var1;
                int var7 = var5 - var2;
                RecipeItemStack var8 = RecipeItemStack.EMPTY;
                if (var6 >= 0 && var7 >= 0 && var6 < this.width && var7 < this.height) {
                    var8 = var3 ? this.ingredients.get(this.width - var6 - 1 + var7 * this.width) : this.ingredients.get(var6 + var7 * this.width);
                }
                if (var8.test(var0.getItem(var4 + var5 * var0.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    private void toNetwork(RegistryFriendlyByteBuf var0) {
        var0.writeVarInt(this.width);
        var0.writeVarInt(this.height);
        for (RecipeItemStack var2 : this.ingredients) {
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(var0, var2);
        }
    }

    private static ShapedRecipePattern fromNetwork(RegistryFriendlyByteBuf var0) {
        int var12 = var0.readVarInt();
        int var2 = var0.readVarInt();
        NonNullList<RecipeItemStack> var3 = NonNullList.withSize(var12 * var2, RecipeItemStack.EMPTY);
        var3.replaceAll(var1 -> (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(var0));
        return new ShapedRecipePattern(var12, var2, var3, Optional.empty());
    }

    private static /* synthetic */ String a(CharSet var0) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(var0);
    }

    public static final class a
    extends Record {
        final Map<Character, RecipeItemStack> key;
        final List<String> pattern;
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(var0 -> {
            if (var0.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (var0.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int var1 = ((String)var0.get(0)).length();
            for (String var3 : var0) {
                if (var3.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (var1 == var3.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)var0);
        }, Function.identity());
        private static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(var0 -> {
            if (var0.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + var0 + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(var0)) {
                return DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.");
            }
            return DataResult.success((Object)Character.valueOf(var0.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<a> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ExtraCodecs.strictUnboundedMap(SYMBOL_CODEC, RecipeItemStack.CODEC_NONEMPTY).fieldOf("key").forGetter(var0 -> var0.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(var0 -> var0.pattern)).apply((Applicative)var02, a::new));

        public a(Map<Character, RecipeItemStack> var0, List<String> var1) {
            this.key = var0;
            this.pattern = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;pattern", "key", "pattern"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;pattern", "key", "pattern"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;pattern", "key", "pattern"}, this, var0);
        }

        public Map<Character, RecipeItemStack> key() {
            return this.key;
        }

        public List<String> pattern() {
            return this.pattern;
        }
    }
}

