/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.serialization.Codec;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;

public interface IRecipe<C extends IInventory> {
    public static final Codec<IRecipe<?>> CODEC = BuiltInRegistries.RECIPE_SERIALIZER.byNameCodec().dispatch(IRecipe::getSerializer, RecipeSerializer::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, IRecipe<?>> STREAM_CODEC = ByteBufCodecs.registry(Registries.RECIPE_SERIALIZER).dispatch(IRecipe::getSerializer, RecipeSerializer::streamCodec);

    public boolean matches(C var1, World var2);

    public ItemStack assemble(C var1, HolderLookup.a var2);

    public boolean canCraftInDimensions(int var1, int var2);

    public ItemStack getResultItem(HolderLookup.a var1);

    default public NonNullList<ItemStack> getRemainingItems(C var0) {
        NonNullList<ItemStack> var1 = NonNullList.withSize(var0.getContainerSize(), ItemStack.EMPTY);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            Item var3 = var0.getItem(var2).getItem();
            if (!var3.hasCraftingRemainingItem()) continue;
            var1.set(var2, new ItemStack(var3.getCraftingRemainingItem()));
        }
        return var1;
    }

    default public NonNullList<RecipeItemStack> getIngredients() {
        return NonNullList.create();
    }

    default public boolean isSpecial() {
        return false;
    }

    default public boolean showNotification() {
        return true;
    }

    default public String getGroup() {
        return "";
    }

    default public ItemStack getToastSymbol() {
        return new ItemStack(Blocks.CRAFTING_TABLE);
    }

    public RecipeSerializer<?> getSerializer();

    public Recipes<?> getType();

    default public boolean isIncomplete() {
        NonNullList<RecipeItemStack> var02 = this.getIngredients();
        return var02.isEmpty() || var02.stream().anyMatch(var0 -> var0.getItems().length == 0);
    }
}

