/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record ItemAttributeModifiers(List<b> modifiers, boolean showInTooltip) {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(List.of(), true);
    private static final Codec<ItemAttributeModifiers> FULL_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)b.CODEC.listOf().fieldOf("modifiers").forGetter(ItemAttributeModifiers::modifiers), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(ItemAttributeModifiers::showInTooltip)).apply((Applicative)var0, ItemAttributeModifiers::new));
    public static final Codec<ItemAttributeModifiers> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)b.CODEC.listOf(), var0 -> new ItemAttributeModifiers((List<b>)var0, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> STREAM_CODEC = StreamCodec.composite(b.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemAttributeModifiers::modifiers, ByteBufCodecs.BOOL, ItemAttributeModifiers::showInTooltip, ItemAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = SystemUtils.make(new DecimalFormat("#.##"), var0 -> var0.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public ItemAttributeModifiers withTooltip(boolean var0) {
        return new ItemAttributeModifiers(this.modifiers, var0);
    }

    public static a builder() {
        return new a();
    }

    public ItemAttributeModifiers withModifierAdded(Holder<AttributeBase> var0, AttributeModifier var1, EquipmentSlotGroup var2) {
        ImmutableList.Builder var3 = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (b var5 : this.modifiers) {
            if (var5.modifier.id().equals(var1.id())) continue;
            var3.add((Object)var5);
        }
        var3.add((Object)new b(var0, var1, var2));
        return new ItemAttributeModifiers((List<b>)var3.build(), this.showInTooltip);
    }

    public void forEach(EnumItemSlot var0, BiConsumer<Holder<AttributeBase>, AttributeModifier> var1) {
        for (b var3 : this.modifiers) {
            if (!var3.slot.test(var0)) continue;
            var1.accept(var3.attribute, var3.modifier);
        }
    }

    public double compute(double var0, EnumItemSlot var2) {
        double var3 = var0;
        for (b var6 : this.modifiers) {
            if (!var6.slot.test(var2)) continue;
            double var7 = var6.modifier.amount();
            var3 += (switch (var6.modifier.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> var7;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> var7 * var0;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> var7 * var3;
            });
        }
        return var3;
    }

    public static class a {
        private final ImmutableList.Builder<b> entries = ImmutableList.builder();

        a() {
        }

        public a add(Holder<AttributeBase> var0, AttributeModifier var1, EquipmentSlotGroup var2) {
            this.entries.add((Object)new b(var0, var1, var2));
            return this;
        }

        public ItemAttributeModifiers build() {
            return new ItemAttributeModifiers((List<b>)this.entries.build(), true);
        }
    }

    public static final class b
    extends Record {
        final Holder<AttributeBase> attribute;
        final AttributeModifier modifier;
        final EquipmentSlotGroup slot;
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("type").forGetter(b::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(b::modifier), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot", (Object)EquipmentSlotGroup.ANY).forGetter(b::slot)).apply((Applicative)var0, b::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, b> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.ATTRIBUTE), b::attribute, AttributeModifier.STREAM_CODEC, b::modifier, EquipmentSlotGroup.STREAM_CODEC, b::slot, b::new);

        public b(Holder<AttributeBase> var0, AttributeModifier var1, EquipmentSlotGroup var2) {
            this.attribute = var0;
            this.modifier = var1;
            this.slot = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "attribute;modifier;slot", "attribute", "modifier", "slot"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "attribute;modifier;slot", "attribute", "modifier", "slot"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "attribute;modifier;slot", "attribute", "modifier", "slot"}, this, var0);
        }

        public Holder<AttributeBase> attribute() {
            return this.attribute;
        }

        public AttributeModifier modifier() {
            return this.modifier;
        }

        public EquipmentSlotGroup slot() {
            return this.slot;
        }
    }
}

