/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ChargedProjectiles {
    public static final ChargedProjectiles EMPTY = new ChargedProjectiles(List.of());
    public static final Codec<ChargedProjectiles> CODEC = ItemStack.CODEC.listOf().xmap(ChargedProjectiles::new, var0 -> var0.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChargedProjectiles> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(ChargedProjectiles::new, var0 -> var0.items);
    private final List<ItemStack> items;

    private ChargedProjectiles(List<ItemStack> var0) {
        this.items = var0;
    }

    public static ChargedProjectiles of(ItemStack var0) {
        return new ChargedProjectiles(List.of(var0.copy()));
    }

    public static ChargedProjectiles of(List<ItemStack> var0) {
        return new ChargedProjectiles(List.copyOf(Lists.transform(var0, ItemStack::copy)));
    }

    public boolean contains(Item var0) {
        for (ItemStack var2 : this.items) {
            if (!var2.is(var0)) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getItems() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ChargedProjectiles)) return false;
        ChargedProjectiles var1 = (ChargedProjectiles)var0;
        if (!ItemStack.listMatches(this.items, var1.items)) return false;
        return true;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "ChargedProjectiles[items=" + String.valueOf(this.items) + "]";
    }
}

