/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class PotionRegistry
implements FeatureElement {
    @Nullable
    private final String name;
    private final List<MobEffect> effects;
    private FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;

    public PotionRegistry(MobEffect ... var0) {
        this((String)null, var0);
    }

    public PotionRegistry(@Nullable String var0, MobEffect ... var1) {
        this.name = var0;
        this.effects = List.of(var1);
    }

    public PotionRegistry requiredFeatures(FeatureFlag ... var0) {
        this.requiredFeatures = FeatureFlags.REGISTRY.subset(var0);
        return this;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    public static String getName(Optional<Holder<PotionRegistry>> var02, String var1) {
        String var2;
        if (var02.isPresent() && (var2 = var02.get().value().name) != null) {
            return var1 + var2;
        }
        var2 = var02.flatMap(Holder::unwrapKey).map(var0 -> var0.location().getPath()).orElse("empty");
        return var1 + var2;
    }

    public List<MobEffect> getEffects() {
        return this.effects;
    }

    public boolean hasInstantEffects() {
        if (!this.effects.isEmpty()) {
            for (MobEffect var1 : this.effects) {
                if (!var1.getEffect().value().isInstantenous()) continue;
                return true;
            }
        }
        return false;
    }
}

