/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;

public class MobBucketItem
extends ItemBucket {
    private static final MapCodec<EntityTropicalFish.d> VARIANT_FIELD_CODEC = EntityTropicalFish.d.CODEC.fieldOf("BucketVariantTag");
    private final EntityTypes<?> type;
    private final SoundEffect emptySound;

    public MobBucketItem(EntityTypes<?> var0, FluidType var1, SoundEffect var2, Item.Info var3) {
        super(var1, var3);
        this.type = var0;
        this.emptySound = var2;
    }

    @Override
    public void checkExtraContent(@Nullable EntityHuman var0, World var1, ItemStack var2, BlockPosition var3) {
        if (var1 instanceof WorldServer) {
            this.spawn((WorldServer)var1, var2, var3);
            var1.gameEvent((Entity)var0, GameEvent.ENTITY_PLACE, var3);
        }
    }

    @Override
    protected void playEmptySound(@Nullable EntityHuman var0, GeneratorAccess var1, BlockPosition var2) {
        var1.playSound(var0, var2, this.emptySound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(WorldServer var0, ItemStack var1, BlockPosition var2) {
        Object var3 = this.type.spawn(var0, var1, null, var2, EnumMobSpawn.BUCKET, true, false);
        if (var3 instanceof Bucketable) {
            Bucketable var4 = (Bucketable)var3;
            CustomData var5 = var1.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, CustomData.EMPTY);
            var4.loadFromBucketTag(var5.copyTag());
            var4.setFromBucket(true);
        }
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        if (this.type == EntityTypes.TROPICAL_FISH) {
            CustomData var4 = var0.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, CustomData.EMPTY);
            if (var4.isEmpty()) {
                return;
            }
            Optional var5 = var4.read(VARIANT_FIELD_CODEC).result();
            if (var5.isPresent()) {
                EntityTropicalFish.d var6 = (EntityTropicalFish.d)var5.get();
                EnumChatFormat[] var7 = new EnumChatFormat[]{EnumChatFormat.ITALIC, EnumChatFormat.GRAY};
                String var8 = "color.minecraft." + String.valueOf(var6.baseColor());
                String var9 = "color.minecraft." + String.valueOf(var6.patternColor());
                int var10 = EntityTropicalFish.COMMON_VARIANTS.indexOf(var6);
                if (var10 != -1) {
                    var2.add(IChatBaseComponent.translatable(EntityTropicalFish.getPredefinedName(var10)).withStyle(var7));
                    return;
                }
                var2.add(var6.pattern().displayName().plainCopy().withStyle(var7));
                IChatMutableComponent var11 = IChatBaseComponent.translatable(var8);
                if (!var8.equals(var9)) {
                    var11.append(", ").append(IChatBaseComponent.translatable(var9));
                }
                var11.withStyle(var7);
                var2.add(var11);
            }
        }
    }
}

