/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.DensityEnchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class MaceItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 6;
    private static final float DEFAULT_ATTACK_SPEED = -2.4f;
    private static final float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private static final float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public static final float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private static final float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;
    private static final float SMASH_ATTACK_FALL_DISTANCE_MULTIPLIER = 3.0f;

    public MaceItem(Item.Info var0) {
        super(var0);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(GenericAttributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", 6.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(GenericAttributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", -2.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        return !var3.isCreative();
    }

    @Override
    public int getEnchantmentValue() {
        return 15;
    }

    @Override
    public boolean hurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        EntityPlayer var3;
        var0.hurtAndBreak(1, var2, EnumItemSlot.MAINHAND);
        if (var2 instanceof EntityPlayer && MaceItem.canSmashAttack(var3 = (EntityPlayer)var2)) {
            WorldServer var4 = (WorldServer)var2.level();
            var3.currentImpulseImpactPos = var3.position();
            var3.ignoreFallDamageFromCurrentImpulse = true;
            var3.setDeltaMovement(var3.getDeltaMovement().with(EnumDirection.EnumAxis.Y, 0.01f));
            var3.connection.send(new PacketPlayOutEntityVelocity(var3));
            if (var1.onGround()) {
                var3.setSpawnExtraParticlesOnFall(true);
                SoundEffect var5 = var3.fallDistance > 5.0f ? SoundEffects.MACE_SMASH_GROUND_HEAVY : SoundEffects.MACE_SMASH_GROUND;
                var4.playSound(null, var3.getX(), var3.getY(), var3.getZ(), var5, var3.getSoundSource(), 1.0f, 1.0f);
            } else {
                var4.playSound(null, var3.getX(), var3.getY(), var3.getZ(), SoundEffects.MACE_SMASH_AIR, var3.getSoundSource(), 1.0f, 1.0f);
            }
            MaceItem.knockback(var4, var3, var1);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidRepairItem(ItemStack var0, ItemStack var1) {
        return var1.is(Items.BREEZE_ROD);
    }

    @Override
    public float getAttackDamageBonus(EntityHuman var0, float var1) {
        int var2 = EnchantmentManager.getEnchantmentLevel(Enchantments.DENSITY, var0);
        float var3 = DensityEnchantment.calculateDamageAddition(var2, var0.fallDistance);
        return MaceItem.canSmashAttack(var0) ? 3.0f * var0.fallDistance + var3 : 0.0f;
    }

    private static void knockback(World var0, EntityHuman var1, Entity var22) {
        var0.levelEvent(2013, var22.getOnPos(), 750);
        var0.getEntitiesOfClass(EntityLiving.class, var22.getBoundingBox().inflate(3.5), MaceItem.knockbackPredicate(var1, var22)).forEach(var2 -> {
            Vec3D var3 = var2.position().subtract(var22.position());
            double var4 = MaceItem.getKnockbackPower(var1, var2, var3);
            Vec3D var6 = var3.normalize().scale(var4);
            if (var4 > 0.0) {
                var2.push(var6.x, 0.7f, var6.z);
            }
        });
    }

    private static Predicate<EntityLiving> knockbackPredicate(EntityHuman var0, Entity var1) {
        return var2 -> {
            EntityArmorStand var7;
            boolean var3 = !var2.isSpectator();
            boolean var4 = var2 != var0 && var2 != var1;
            boolean var5 = !var0.isAlliedTo((Entity)var2);
            boolean var6 = !(var2 instanceof EntityArmorStand) || !(var7 = (EntityArmorStand)var2).isMarker();
            boolean var8 = var1.distanceToSqr((Entity)var2) <= Math.pow(3.5, 2.0);
            return var3 && var4 && var5 && var6 && var8;
        };
    }

    private static double getKnockbackPower(EntityHuman var0, EntityLiving var1, Vec3D var2) {
        return (3.5 - var2.length()) * (double)0.7f * (double)(var0.fallDistance > 5.0f ? 2 : 1) * (1.0 - var1.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(EntityHuman var0) {
        return var0.fallDistance > 1.5f && !var0.isFallFlying();
    }
}

