/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.World;

public class ItemSuspiciousStew
extends Item {
    public static final int DEFAULT_DURATION = 160;

    public ItemSuspiciousStew(Item.Info var0) {
        super(var0);
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        if (var3.isCreative()) {
            ArrayList<MobEffect> var4 = new ArrayList<MobEffect>();
            SuspiciousStewEffects var5 = var0.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY);
            for (SuspiciousStewEffects.a var7 : var5.effects()) {
                var4.add(var7.createEffectInstance());
            }
            PotionContents.addPotionTooltip(var4, var2::add, 1.0f, var1.tickRate());
        }
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        SuspiciousStewEffects var3 = var0.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY);
        for (SuspiciousStewEffects.a var5 : var3.effects()) {
            var2.addEffect(var5.createEffectInstance());
        }
        super.finishUsingItem(var0, var1, var2);
        if (var2.hasInfiniteMaterials()) {
            return var0;
        }
        return new ItemStack(Items.BOWL);
    }
}

