/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentDurability;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    public static final Codec<Holder<Item>> ITEM_NON_AIR_CODEC = BuiltInRegistries.ITEM.holderByNameCodec().validate(var0 -> var0.is(Items.AIR.builtInRegistryHolder()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)var0));
    public static final Codec<ItemStack> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(var02 -> var02.group((App)ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.POSITIVE_INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(var0 -> var0.components.asPatch())).apply((Applicative)var02, ItemStack::new)));
    public static final Codec<ItemStack> SINGLE_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(var02 -> var02.group((App)ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(var0 -> var0.components.asPatch())).apply((Applicative)var02, (var0, var1) -> new ItemStack((Holder<Item>)var0, 1, (DataComponentPatch)var1))));
    public static final Codec<ItemStack> STRICT_CODEC = CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> STRICT_SINGLE_ITEM_CODEC = SINGLE_ITEM_CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(var0 -> var0.orElse(EMPTY), var0 -> var0.isEmpty() ? Optional.empty() : Optional.of(var0));
    public static final Codec<ItemStack> SIMPLE_ITEM_CODEC = ITEM_NON_AIR_CODEC.xmap(ItemStack::new, ItemStack::getItemHolder);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> ITEM_STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ITEM);

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf var0) {
            int var1 = var0.readVarInt();
            if (var1 <= 0) {
                return EMPTY;
            }
            Holder var2 = (Holder)ITEM_STREAM_CODEC.decode(var0);
            DataComponentPatch var3 = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode(var0);
            return new ItemStack(var2, var1, var3);
        }

        @Override
        public void encode(RegistryFriendlyByteBuf var0, ItemStack var1) {
            if (var1.isEmpty()) {
                var0.writeVarInt(0);
                return;
            }
            var0.writeVarInt(var1.getCount());
            ITEM_STREAM_CODEC.encode(var0, var1.getItemHolder());
            DataComponentPatch.STREAM_CODEC.encode(var0, var1.components.asPatch());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((RegistryFriendlyByteBuf)((Object)object), (ItemStack)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((RegistryFriendlyByteBuf)((Object)object));
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf var0) {
            ItemStack var1 = (ItemStack)OPTIONAL_STREAM_CODEC.decode(var0);
            if (var1.isEmpty()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return var1;
        }

        @Override
        public void encode(RegistryFriendlyByteBuf var0, ItemStack var1) {
            if (var1.isEmpty()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((RegistryFriendlyByteBuf)((Object)object), (ItemStack)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((RegistryFriendlyByteBuf)((Object)object));
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> OPTIONAL_LIST_STREAM_CODEC = OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ItemStack EMPTY = new ItemStack((Void)null);
    private static final IChatBaseComponent DISABLED_ITEM_TOOLTIP = IChatBaseComponent.translatable("item.disabled").withStyle(EnumChatFormat.RED);
    private int count;
    private int popTime;
    @Deprecated
    @Nullable
    private Item item;
    final PatchedDataComponentMap components;
    @Nullable
    private Entity entityRepresentation;

    private static DataResult<ItemStack> validateStrict(ItemStack var0) {
        DataResult<Unit> var12 = ItemStack.validateComponents(var0.getComponents());
        if (var12.isError()) {
            return var12.map(var1 -> var0);
        }
        if (var0.getCount() > var0.getMaxStackSize()) {
            return DataResult.error(() -> "Item stack with stack size of " + var0.getCount() + " was larger than maximum: " + var0.getMaxStackSize());
        }
        return DataResult.success((Object)var0);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> validatedStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> var0) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf var02) {
                ItemStack var1 = (ItemStack)var0.decode(var02);
                if (!var1.isEmpty()) {
                    RegistryOps<Unit> var2 = var02.registryAccess().createSerializationContext(NullOps.INSTANCE);
                    CODEC.encodeStart(var2, (Object)var1).getOrThrow(DecoderException::new);
                }
                return var1;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, ItemStack var1) {
                var0.encode(var02, var1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (ItemStack)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return this.getItem().getTooltipImage(this);
    }

    @Override
    public DataComponentMap getComponents() {
        return !this.isEmpty() ? this.components : DataComponentMap.EMPTY;
    }

    public DataComponentMap getPrototype() {
        return !this.isEmpty() ? this.getItem().components() : DataComponentMap.EMPTY;
    }

    public DataComponentPatch getComponentsPatch() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public ItemStack(IMaterial var0) {
        this(var0, 1);
    }

    public ItemStack(Holder<Item> var0) {
        this(var0.value(), 1);
    }

    public ItemStack(Holder<Item> var0, int var1, DataComponentPatch var2) {
        this(var0.value(), var1, PatchedDataComponentMap.fromPatch(var0.value().components(), var2));
    }

    public ItemStack(Holder<Item> var0, int var1) {
        this(var0.value(), var1);
    }

    public ItemStack(IMaterial var0, int var1) {
        this(var0, var1, new PatchedDataComponentMap(var0.asItem().components()));
    }

    private ItemStack(IMaterial var0, int var1, PatchedDataComponentMap var2) {
        this.item = var0.asItem();
        this.count = var1;
        this.components = var2;
        this.getItem().verifyComponentsAfterLoad(this);
    }

    private ItemStack(@Nullable Void var0) {
        this.item = null;
        this.components = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    public static DataResult<Unit> validateComponents(DataComponentMap var0) {
        if (var0.has(DataComponents.MAX_DAMAGE) && var0.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        return DataResult.success((Object)((Object)Unit.INSTANCE));
    }

    public static Optional<ItemStack> parse(HolderLookup.a var02, NBTBase var1) {
        return CODEC.parse(var02.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var1).resultOrPartial(var0 -> LOGGER.error("Tried to load invalid item: '{}'", var0));
    }

    public static ItemStack parseOptional(HolderLookup.a var0, NBTTagCompound var1) {
        if (var1.isEmpty()) {
            return EMPTY;
        }
        return ItemStack.parse(var0, var1).orElse(EMPTY);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.AIR || this.count <= 0;
    }

    public boolean isItemEnabled(FeatureFlagSet var0) {
        return this.isEmpty() || this.getItem().isEnabled(var0);
    }

    public ItemStack split(int var0) {
        int var1 = Math.min(var0, this.getCount());
        ItemStack var2 = this.copyWithCount(var1);
        this.shrink(var1);
        return var2;
    }

    public ItemStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack var0 = this.copy();
        this.setCount(0);
        return var0;
    }

    public Item getItem() {
        return this.isEmpty() ? Items.AIR : this.item;
    }

    public Holder<Item> getItemHolder() {
        return this.getItem().builtInRegistryHolder();
    }

    public boolean is(TagKey<Item> var0) {
        return this.getItem().builtInRegistryHolder().is(var0);
    }

    public boolean is(Item var0) {
        return this.getItem() == var0;
    }

    public boolean is(Predicate<Holder<Item>> var0) {
        return var0.test(this.getItem().builtInRegistryHolder());
    }

    public boolean is(Holder<Item> var0) {
        return this.getItem().builtInRegistryHolder() == var0;
    }

    public boolean is(HolderSet<Item> var0) {
        return var0.contains(this.getItemHolder());
    }

    public Stream<TagKey<Item>> getTags() {
        return this.getItem().builtInRegistryHolder().tags();
    }

    public EnumInteractionResult useOn(ItemActionContext var0) {
        EntityHuman var1 = var0.getPlayer();
        BlockPosition var2 = var0.getClickedPos();
        if (var1 != null && !var1.getAbilities().mayBuild && !this.canPlaceOnBlockInAdventureMode(new ShapeDetectorBlock(var0.getLevel(), var2, false))) {
            return EnumInteractionResult.PASS;
        }
        Item var3 = this.getItem();
        EnumInteractionResult var4 = var3.useOn(var0);
        if (var1 != null && var4.indicateItemUse()) {
            var1.awardStat(StatisticList.ITEM_USED.get(var3));
        }
        return var4;
    }

    public float getDestroySpeed(IBlockData var0) {
        return this.getItem().getDestroySpeed(this, var0);
    }

    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        return this.getItem().use(var0, var1, var2);
    }

    public ItemStack finishUsingItem(World var0, EntityLiving var1) {
        return this.getItem().finishUsingItem(this, var0, var1);
    }

    public NBTBase save(HolderLookup.a var0, NBTBase var1) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)CODEC.encode((Object)this, var0.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var1).getOrThrow();
    }

    public NBTBase save(HolderLookup.a var0) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)CODEC.encodeStart(var0.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)this).getOrThrow();
    }

    public NBTBase saveOptional(HolderLookup.a var0) {
        if (this.isEmpty()) {
            return new NBTTagCompound();
        }
        return this.save(var0, new NBTTagCompound());
    }

    public int getMaxStackSize() {
        return this.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return this.has(DataComponents.MAX_DAMAGE) && !this.has(DataComponents.UNBREAKABLE) && this.has(DataComponents.DAMAGE);
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        return MathHelper.clamp(this.getOrDefault(DataComponents.DAMAGE, 0), 0, this.getMaxDamage());
    }

    public void setDamageValue(int var0) {
        this.set(DataComponents.DAMAGE, MathHelper.clamp(var0, 0, this.getMaxDamage()));
    }

    public int getMaxDamage() {
        return this.getOrDefault(DataComponents.MAX_DAMAGE, 0);
    }

    public void hurtAndBreak(int var0, RandomSource var1, @Nullable EntityPlayer var2, Runnable var3) {
        int var4;
        if (!this.isDamageableItem()) {
            return;
        }
        if (var0 > 0) {
            var4 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.UNBREAKING, this);
            int var5 = 0;
            for (int var6 = 0; var4 > 0 && var6 < var0; ++var6) {
                if (!EnchantmentDurability.shouldIgnoreDurabilityDrop(this, var4, var1)) continue;
                ++var5;
            }
            if ((var0 -= var5) <= 0) {
                return;
            }
        }
        if (var2 != null && var0 != 0) {
            CriterionTriggers.ITEM_DURABILITY_CHANGED.trigger(var2, this, this.getDamageValue() + var0);
        }
        var4 = this.getDamageValue() + var0;
        this.setDamageValue(var4);
        if (var4 >= this.getMaxDamage()) {
            var3.run();
        }
    }

    public void hurtAndBreak(int var0, EntityLiving var1, EnumItemSlot var2) {
        EntityHuman var3;
        if (var1.level().isClientSide || var1 instanceof EntityHuman && (var3 = (EntityHuman)var1).hasInfiniteMaterials()) {
            return;
        }
        this.hurtAndBreak(var0, var1.getRandom(), (EntityPlayer)(var1 instanceof EntityPlayer ? (var3 = (EntityPlayer)var1) : null), () -> {
            var1.broadcastBreakEvent(var2);
            Item var2 = this.getItem();
            this.shrink(1);
            if (var1 instanceof EntityHuman) {
                ((EntityHuman)var1).awardStat(StatisticList.ITEM_BROKEN.get(var2));
            }
            this.setDamageValue(0);
        });
    }

    public boolean isBarVisible() {
        return this.getItem().isBarVisible(this);
    }

    public int getBarWidth() {
        return this.getItem().getBarWidth(this);
    }

    public int getBarColor() {
        return this.getItem().getBarColor(this);
    }

    public boolean overrideStackedOnOther(Slot var0, ClickAction var1, EntityHuman var2) {
        return this.getItem().overrideStackedOnOther(this, var0, var1, var2);
    }

    public boolean overrideOtherStackedOnMe(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3, SlotAccess var4) {
        return this.getItem().overrideOtherStackedOnMe(this, var0, var1, var2, var3, var4);
    }

    public void hurtEnemy(EntityLiving var0, EntityHuman var1) {
        Item var2 = this.getItem();
        ItemEnchantments var3 = this.getEnchantments();
        if (var2.hurtEnemy(this, var0, var1)) {
            var1.awardStat(StatisticList.ITEM_USED.get(var2));
            EnchantmentManager.doPostItemStackHurtEffects(var1, var0, var3);
        }
    }

    public void mineBlock(World var0, IBlockData var1, BlockPosition var2, EntityHuman var3) {
        Item var4 = this.getItem();
        if (var4.mineBlock(this, var0, var1, var2, var3)) {
            var3.awardStat(StatisticList.ITEM_USED.get(var4));
        }
    }

    public boolean isCorrectToolForDrops(IBlockData var0) {
        return this.getItem().isCorrectToolForDrops(this, var0);
    }

    public EnumInteractionResult interactLivingEntity(EntityHuman var0, EntityLiving var1, EnumHand var2) {
        return this.getItem().interactLivingEntity(this, var0, var1, var2);
    }

    public ItemStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack var0 = new ItemStack(this.getItem(), this.count, this.components.copy());
        var0.setPopTime(this.getPopTime());
        return var0;
    }

    public ItemStack copyWithCount(int var0) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack var1 = this.copy();
        var1.setCount(var0);
        return var1;
    }

    public ItemStack transmuteCopy(IMaterial var0, int var1) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return this.transmuteCopyIgnoreEmpty(var0, var1);
    }

    public ItemStack transmuteCopyIgnoreEmpty(IMaterial var0, int var1) {
        return new ItemStack(var0.asItem().builtInRegistryHolder(), var1, this.components.asPatch());
    }

    public static boolean matches(ItemStack var0, ItemStack var1) {
        if (var0 == var1) {
            return true;
        }
        if (var0.getCount() != var1.getCount()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents(var0, var1);
    }

    @Deprecated
    public static boolean listMatches(List<ItemStack> var0, List<ItemStack> var1) {
        if (var0.size() != var1.size()) {
            return false;
        }
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            if (ItemStack.matches(var0.get(var2), var1.get(var2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameItem(ItemStack var0, ItemStack var1) {
        return var0.is(var1.getItem());
    }

    public static boolean isSameItemSameComponents(ItemStack var0, ItemStack var1) {
        if (!var0.is(var1.getItem())) {
            return false;
        }
        if (var0.isEmpty() && var1.isEmpty()) {
            return true;
        }
        return Objects.equals(var0.components, var1.components);
    }

    public static MapCodec<ItemStack> lenientOptionalFieldOf(String var02) {
        return CODEC.lenientOptionalFieldOf(var02).xmap(var0 -> var0.orElse(EMPTY), var0 -> var0.isEmpty() ? Optional.empty() : Optional.of(var0));
    }

    public static int hashItemAndComponents(@Nullable ItemStack var0) {
        if (var0 != null) {
            int var1 = 31 + var0.getItem().hashCode();
            return 31 * var1 + var0.getComponents().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int hashStackList(List<ItemStack> var0) {
        int var1 = 0;
        for (ItemStack var3 : var0) {
            var1 = var1 * 31 + ItemStack.hashItemAndComponents(var3);
        }
        return var1;
    }

    public String getDescriptionId() {
        return this.getItem().getDescriptionId(this);
    }

    public String toString() {
        return this.getCount() + " " + String.valueOf(this.getItem());
    }

    public void inventoryTick(World var0, Entity var1, int var2, boolean var3) {
        if (this.popTime > 0) {
            --this.popTime;
        }
        if (this.getItem() != null) {
            this.getItem().inventoryTick(this, var0, var1, var2, var3);
        }
    }

    public void onCraftedBy(World var0, EntityHuman var1, int var2) {
        var1.awardStat(StatisticList.ITEM_CRAFTED.get(this.getItem()), var2);
        this.getItem().onCraftedBy(this, var0, var1);
    }

    public void onCraftedBySystem(World var0) {
        this.getItem().onCraftedPostProcess(this, var0);
    }

    public int getUseDuration() {
        return this.getItem().getUseDuration(this);
    }

    public EnumAnimation getUseAnimation() {
        return this.getItem().getUseAnimation(this);
    }

    public void releaseUsing(World var0, EntityLiving var1, int var2) {
        this.getItem().releaseUsing(this, var0, var1, var2);
    }

    public boolean useOnRelease() {
        return this.getItem().useOnRelease(this);
    }

    @Nullable
    public <T> T set(DataComponentType<? super T> var0, @Nullable T var1) {
        return this.components.set(var0, var1);
    }

    @Nullable
    public <T, U> T update(DataComponentType<T> var0, T var1, U var2, BiFunction<T, U, T> var3) {
        return this.set(var0, var3.apply(this.getOrDefault(var0, var1), var2));
    }

    @Nullable
    public <T> T update(DataComponentType<T> var0, T var1, UnaryOperator<T> var2) {
        T var3 = this.getOrDefault(var0, var1);
        return this.set(var0, var2.apply(var3));
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> var0) {
        return this.components.remove(var0);
    }

    public void applyComponentsAndValidate(DataComponentPatch var0) {
        DataComponentPatch var1 = this.components.asPatch();
        this.components.applyPatch(var0);
        Optional var2 = ItemStack.validateStrict(this).error();
        if (var2.isPresent()) {
            LOGGER.error("Failed to apply component patch '{}' to item: '{}'", (Object)var0, (Object)((DataResult.Error)var2.get()).message());
            this.components.restorePatch(var1);
            return;
        }
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentPatch var0) {
        this.components.applyPatch(var0);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentMap var0) {
        this.components.setAll(var0);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public IChatBaseComponent getHoverName() {
        IChatBaseComponent var0 = this.get(DataComponents.CUSTOM_NAME);
        if (var0 != null) {
            return var0;
        }
        IChatBaseComponent var1 = this.get(DataComponents.ITEM_NAME);
        if (var1 != null) {
            return var1;
        }
        return this.getItem().getName(this);
    }

    private <T extends TooltipProvider> void addToTooltip(DataComponentType<T> var0, Item.b var1, Consumer<IChatBaseComponent> var2, TooltipFlag var3) {
        TooltipProvider var4 = (TooltipProvider)this.get(var0);
        if (var4 != null) {
            var4.addToTooltip(var1, var2, var3);
        }
    }

    public List<IChatBaseComponent> getTooltipLines(Item.b var0, @Nullable EntityHuman var1, TooltipFlag var2) {
        AdventureModePredicate var7;
        Object var5;
        if (!var2.isCreative() && this.has(DataComponents.HIDE_TOOLTIP)) {
            return List.of();
        }
        ArrayList var3 = Lists.newArrayList();
        IChatMutableComponent var4 = IChatBaseComponent.empty().append(this.getHoverName()).withStyle(this.getRarity().color());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            var4.withStyle(EnumChatFormat.ITALIC);
        }
        var3.add(var4);
        if (!var2.isAdvanced() && !this.has(DataComponents.CUSTOM_NAME) && this.is(Items.FILLED_MAP) && (var5 = this.get(DataComponents.MAP_ID)) != null) {
            var3.add(ItemWorldMap.getTooltipForId((MapId)var5));
        }
        var5 = var3::add;
        if (!this.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            this.getItem().appendHoverText(this, var0, var3, var2);
        }
        this.addToTooltip(DataComponents.TRIM, var0, (Consumer<IChatBaseComponent>)var5, var2);
        this.addToTooltip(DataComponents.STORED_ENCHANTMENTS, var0, (Consumer<IChatBaseComponent>)var5, var2);
        this.addToTooltip(DataComponents.ENCHANTMENTS, var0, (Consumer<IChatBaseComponent>)var5, var2);
        this.addToTooltip(DataComponents.DYED_COLOR, var0, (Consumer<IChatBaseComponent>)var5, var2);
        this.addToTooltip(DataComponents.LORE, var0, (Consumer<IChatBaseComponent>)var5, var2);
        this.addAttributeTooltips((Consumer<IChatBaseComponent>)var5, var1);
        this.addToTooltip(DataComponents.UNBREAKABLE, var0, (Consumer<IChatBaseComponent>)var5, var2);
        AdventureModePredicate var6 = this.get(DataComponents.CAN_BREAK);
        if (var6 != null && var6.showInTooltip()) {
            var5.accept(CommonComponents.EMPTY);
            var5.accept(AdventureModePredicate.CAN_BREAK_HEADER);
            var6.addToTooltip((Consumer<IChatBaseComponent>)var5);
        }
        if ((var7 = this.get(DataComponents.CAN_PLACE_ON)) != null && var7.showInTooltip()) {
            var5.accept(CommonComponents.EMPTY);
            var5.accept(AdventureModePredicate.CAN_PLACE_HEADER);
            var7.addToTooltip((Consumer<IChatBaseComponent>)var5);
        }
        if (var2.isAdvanced()) {
            if (this.isDamaged()) {
                var3.add(IChatBaseComponent.translatable("item.durability", this.getMaxDamage() - this.getDamageValue(), this.getMaxDamage()));
            }
            var3.add(IChatBaseComponent.literal(BuiltInRegistries.ITEM.getKey(this.getItem()).toString()).withStyle(EnumChatFormat.DARK_GRAY));
            int var8 = this.components.size();
            if (var8 > 0) {
                var3.add(IChatBaseComponent.translatable("item.components", var8).withStyle(EnumChatFormat.DARK_GRAY));
            }
        }
        if (var1 != null && !this.getItem().isEnabled(var1.level().enabledFeatures())) {
            var3.add(DISABLED_ITEM_TOOLTIP);
        }
        return var3;
    }

    private void addAttributeTooltips(Consumer<IChatBaseComponent> var0, @Nullable EntityHuman var1) {
        ItemAttributeModifiers var2 = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        if (!var2.showInTooltip()) {
            return;
        }
        for (EnumItemSlot var6 : EnumItemSlot.values()) {
            MutableBoolean var7 = new MutableBoolean(true);
            this.forEachModifier(var6, (var4, var5) -> {
                if (var7.isTrue()) {
                    var0.accept(CommonComponents.EMPTY);
                    var0.accept(IChatBaseComponent.translatable("item.modifiers." + var6.getName()).withStyle(EnumChatFormat.GRAY));
                    var7.setFalse();
                }
                this.addModifierTooltip(var0, var1, (Holder<AttributeBase>)var4, (AttributeModifier)var5);
            });
        }
    }

    private void addModifierTooltip(Consumer<IChatBaseComponent> var0, @Nullable EntityHuman var1, Holder<AttributeBase> var2, AttributeModifier var3) {
        double var4 = var3.amount();
        boolean var6 = false;
        if (var1 != null) {
            if (var3.id() == Item.BASE_ATTACK_DAMAGE_UUID) {
                var4 += var1.getAttributeBaseValue(GenericAttributes.ATTACK_DAMAGE);
                var4 += (double)EnchantmentManager.getDamageBonus(this, null);
                var6 = true;
            } else if (var3.id() == Item.BASE_ATTACK_SPEED_UUID) {
                var4 += var1.getAttributeBaseValue(GenericAttributes.ATTACK_SPEED);
                var6 = true;
            }
        }
        double var7 = var3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || var3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? var4 * 100.0 : (var2.is(GenericAttributes.KNOCKBACK_RESISTANCE) ? var4 * 10.0 : var4);
        if (var6) {
            var0.accept(CommonComponents.space().append(IChatBaseComponent.translatable("attribute.modifier.equals." + var3.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(var7), IChatBaseComponent.translatable(var2.value().getDescriptionId()))).withStyle(EnumChatFormat.DARK_GREEN));
        } else if (var4 > 0.0) {
            var0.accept(IChatBaseComponent.translatable("attribute.modifier.plus." + var3.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(var7), IChatBaseComponent.translatable(var2.value().getDescriptionId())).withStyle(EnumChatFormat.BLUE));
        } else if (var4 < 0.0) {
            var0.accept(IChatBaseComponent.translatable("attribute.modifier.take." + var3.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-var7), IChatBaseComponent.translatable(var2.value().getDescriptionId())).withStyle(EnumChatFormat.RED));
        }
    }

    public boolean hasFoil() {
        Boolean var0 = this.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        if (var0 != null) {
            return var0;
        }
        return this.getItem().isFoil(this);
    }

    public EnumItemRarity getRarity() {
        EnumItemRarity var0 = this.getOrDefault(DataComponents.RARITY, EnumItemRarity.COMMON);
        if (!this.isEnchanted()) {
            return var0;
        }
        return switch (var0) {
            case EnumItemRarity.COMMON, EnumItemRarity.UNCOMMON -> EnumItemRarity.RARE;
            case EnumItemRarity.RARE -> EnumItemRarity.EPIC;
            default -> var0;
        };
    }

    public boolean isEnchantable() {
        if (this.getItem().isEnchantable(this)) {
            ItemEnchantments var0 = this.get(DataComponents.ENCHANTMENTS);
            return var0 != null && var0.isEmpty();
        }
        return false;
    }

    public void enchant(Enchantment var0, int var1) {
        EnchantmentManager.updateEnchantments(this, var2 -> var2.upgrade(var0, var1));
    }

    public boolean isEnchanted() {
        return !this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public ItemEnchantments getEnchantments() {
        return this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
    }

    public boolean isFramed() {
        return this.entityRepresentation instanceof EntityItemFrame;
    }

    public void setEntityRepresentation(@Nullable Entity var0) {
        if (!this.isEmpty()) {
            this.entityRepresentation = var0;
        }
    }

    @Nullable
    public EntityItemFrame getFrame() {
        return this.entityRepresentation instanceof EntityItemFrame ? (EntityItemFrame)this.getEntityRepresentation() : null;
    }

    @Nullable
    public Entity getEntityRepresentation() {
        return !this.isEmpty() ? this.entityRepresentation : null;
    }

    public void forEachModifier(EnumItemSlot var0, BiConsumer<Holder<AttributeBase>, AttributeModifier> var1) {
        ItemAttributeModifiers var2 = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        if (!var2.modifiers().isEmpty()) {
            var2.forEach(var0, var1);
        } else {
            this.getItem().getDefaultAttributeModifiers().forEach(var0, var1);
        }
    }

    public IChatBaseComponent getDisplayName() {
        IChatMutableComponent var02 = IChatBaseComponent.empty().append(this.getHoverName());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            var02.withStyle(EnumChatFormat.ITALIC);
        }
        IChatMutableComponent var1 = ChatComponentUtils.wrapInSquareBrackets(var02);
        if (!this.isEmpty()) {
            var1.withStyle(this.getRarity().color()).withStyle(var0 -> var0.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ITEM, new ChatHoverable.c(this))));
        }
        return var1;
    }

    public boolean canPlaceOnBlockInAdventureMode(ShapeDetectorBlock var0) {
        AdventureModePredicate var1 = this.get(DataComponents.CAN_PLACE_ON);
        return var1 != null && var1.test(var0);
    }

    public boolean canBreakBlockInAdventureMode(ShapeDetectorBlock var0) {
        AdventureModePredicate var1 = this.get(DataComponents.CAN_BREAK);
        return var1 != null && var1.test(var0);
    }

    public int getPopTime() {
        return this.popTime;
    }

    public void setPopTime(int var0) {
        this.popTime = var0;
    }

    public int getCount() {
        return this.isEmpty() ? 0 : this.count;
    }

    public void setCount(int var0) {
        this.count = var0;
    }

    public void limitSize(int var0) {
        if (!this.isEmpty() && this.getCount() > var0) {
            this.setCount(var0);
        }
    }

    public void grow(int var0) {
        this.setCount(this.getCount() + var0);
    }

    public void shrink(int var0) {
        this.grow(-var0);
    }

    public void consume(int var0, @Nullable EntityLiving var1) {
        if (var1 == null || !var1.hasInfiniteMaterials()) {
            this.shrink(var0);
        }
    }

    public void onUseTick(World var0, EntityLiving var1, int var2) {
        this.getItem().onUseTick(var0, var1, this, var2);
    }

    public void onDestroyed(EntityItem var0) {
        this.getItem().onDestroyed(var0);
    }

    public SoundEffect getDrinkingSound() {
        return this.getItem().getDrinkingSound();
    }

    public SoundEffect getEatingSound() {
        return this.getItem().getEatingSound();
    }

    public SoundEffect getBreakingSound() {
        return this.getItem().getBreakingSound();
    }

    public boolean canBeHurtBy(DamageSource var0) {
        return !this.has(DataComponents.FIRE_RESISTANT) || !var0.is(DamageTypeTags.IS_FIRE);
    }
}

