/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;

public abstract class ItemProjectileWeapon
extends Item {
    public static final Predicate<ItemStack> ARROW_ONLY = var0 -> var0.is(TagsItem.ARROWS);
    public static final Predicate<ItemStack> ARROW_OR_FIREWORK = ARROW_ONLY.or(var0 -> var0.is(Items.FIREWORK_ROCKET));

    public ItemProjectileWeapon(Item.Info var0) {
        super(var0);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    public static ItemStack getHeldProjectile(EntityLiving var0, Predicate<ItemStack> var1) {
        if (var1.test(var0.getItemInHand(EnumHand.OFF_HAND))) {
            return var0.getItemInHand(EnumHand.OFF_HAND);
        }
        if (var1.test(var0.getItemInHand(EnumHand.MAIN_HAND))) {
            return var0.getItemInHand(EnumHand.MAIN_HAND);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    public abstract int getDefaultProjectileRange();

    protected void shoot(World var0, EntityLiving var1, EnumHand var2, ItemStack var3, List<ItemStack> var4, float var5, float var6, boolean var7, @Nullable EntityLiving var8) {
        float var9 = 10.0f;
        float var10 = var4.size() == 1 ? 0.0f : 20.0f / (float)(var4.size() - 1);
        float var11 = (float)((var4.size() - 1) % 2) * var10 / 2.0f;
        float var12 = 1.0f;
        for (int var13 = 0; var13 < var4.size(); ++var13) {
            ItemStack var14 = var4.get(var13);
            if (var14.isEmpty()) continue;
            float var15 = var11 + var12 * (float)((var13 + 1) / 2) * var10;
            var12 = -var12;
            var3.hurtAndBreak(this.getDurabilityUse(var14), var1, EntityLiving.getSlotForHand(var2));
            IProjectile var16 = this.createProjectile(var0, var1, var3, var14, var7);
            this.shootProjectile(var1, var16, var13, var5, var6, var15, var8);
            var0.addFreshEntity(var16);
        }
    }

    protected int getDurabilityUse(ItemStack var0) {
        return 1;
    }

    protected abstract void shootProjectile(EntityLiving var1, IProjectile var2, int var3, float var4, float var5, float var6, @Nullable EntityLiving var7);

    protected IProjectile createProjectile(World var0, EntityLiving var1, ItemStack var2, ItemStack var3, boolean var4) {
        int var9;
        int var8;
        int var7;
        ItemArrow itemArrow;
        Object var6;
        Item item = var3.getItem();
        if (item instanceof ItemArrow) {
            var6 = (ItemArrow)item;
            itemArrow = var6;
        } else {
            itemArrow = (ItemArrow)Items.ARROW;
        }
        ItemArrow var5 = itemArrow;
        var6 = var5.createArrow(var0, var3, var1);
        if (var4) {
            ((EntityArrow)var6).setCritArrow(true);
        }
        if ((var7 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.POWER, var2)) > 0) {
            ((EntityArrow)var6).setBaseDamage(((EntityArrow)var6).getBaseDamage() + (double)var7 * 0.5 + 0.5);
        }
        if ((var8 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.PUNCH, var2)) > 0) {
            ((EntityArrow)var6).setKnockback(var8);
        }
        if (EnchantmentManager.getItemEnchantmentLevel(Enchantments.FLAME, var2) > 0) {
            ((Entity)var6).igniteForSeconds(100);
        }
        if ((var9 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.PIERCING, var2)) > 0) {
            ((EntityArrow)var6).setPierceLevel((byte)var9);
        }
        return var6;
    }

    protected static boolean hasInfiniteArrows(ItemStack var0, ItemStack var1, boolean var2) {
        return var2 || var1.is(Items.ARROW) && EnchantmentManager.getItemEnchantmentLevel(Enchantments.INFINITY, var0) > 0;
    }

    protected static List<ItemStack> draw(ItemStack var0, ItemStack var1, EntityLiving var2) {
        if (var1.isEmpty()) {
            return List.of();
        }
        int var3 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.MULTISHOT, var0);
        int var4 = var3 == 0 ? 1 : 3;
        ArrayList<ItemStack> var5 = new ArrayList<ItemStack>(var4);
        ItemStack var6 = var1.copy();
        for (int var7 = 0; var7 < var4; ++var7) {
            var5.add(ItemProjectileWeapon.useAmmo(var0, var7 == 0 ? var1 : var6, var2, var7 > 0));
        }
        return var5;
    }

    protected static ItemStack useAmmo(ItemStack var0, ItemStack var1, EntityLiving var2, boolean var3) {
        boolean var4;
        boolean bl = var4 = !var3 && !ItemProjectileWeapon.hasInfiniteArrows(var0, var1, var2.hasInfiniteMaterials());
        if (!var4) {
            ItemStack var5 = var1.copyWithCount(1);
            var5.set(DataComponents.INTANGIBLE_PROJECTILE, Unit.INSTANCE);
            return var5;
        }
        ItemStack var5 = var1.split(1);
        if (var1.isEmpty() && var2 instanceof EntityHuman) {
            EntityHuman var6 = (EntityHuman)var2;
            var6.getInventory().removeItem(var1);
        }
        return var5;
    }
}

