/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;

public class ItemBow
extends ItemProjectileWeapon {
    public static final int MAX_DRAW_DURATION = 20;
    public static final int DEFAULT_RANGE = 15;

    public ItemBow(Item.Info var0) {
        super(var0);
    }

    @Override
    public void releaseUsing(ItemStack var0, World var1, EntityLiving var2, int var3) {
        if (!(var2 instanceof EntityHuman)) {
            return;
        }
        EntityHuman var4 = (EntityHuman)var2;
        ItemStack var5 = var4.getProjectile(var0);
        if (var5.isEmpty()) {
            return;
        }
        int var6 = this.getUseDuration(var0) - var3;
        float var7 = ItemBow.getPowerForTime(var6);
        if ((double)var7 < 0.1) {
            return;
        }
        List<ItemStack> var8 = ItemBow.draw(var0, var5, var4);
        if (!var1.isClientSide() && !var8.isEmpty()) {
            this.shoot(var1, var4, var4.getUsedItemHand(), var0, var8, var7 * 3.0f, 1.0f, var7 == 1.0f, null);
        }
        var1.playSound(null, var4.getX(), var4.getY(), var4.getZ(), SoundEffects.ARROW_SHOOT, SoundCategory.PLAYERS, 1.0f, 1.0f / (var1.getRandom().nextFloat() * 0.4f + 1.2f) + var7 * 0.5f);
        var4.awardStat(StatisticList.ITEM_USED.get(this));
    }

    @Override
    protected void shootProjectile(EntityLiving var0, IProjectile var1, int var2, float var3, float var4, float var5, @Nullable EntityLiving var6) {
        var1.shootFromRotation(var0, var0.getXRot(), var0.getYRot() + var5, 0.0f, var3, var4);
    }

    public static float getPowerForTime(int var0) {
        float var1 = (float)var0 / 20.0f;
        if ((var1 = (var1 * var1 + var1 * 2.0f) / 3.0f) > 1.0f) {
            var1 = 1.0f;
        }
        return var1;
    }

    @Override
    public int getUseDuration(ItemStack var0) {
        return 72000;
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.BOW;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        boolean var4;
        ItemStack var3 = var1.getItemInHand(var2);
        boolean bl = var4 = !var1.getProjectile(var3).isEmpty();
        if (var1.hasInfiniteMaterials() || var4) {
            var1.startUsingItem(var2);
            return InteractionResultWrapper.consume(var3);
        }
        return InteractionResultWrapper.fail(var3);
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public int getDefaultProjectileRange() {
        return 15;
    }
}

