/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class ItemBlock
extends Item {
    @Deprecated
    private final Block block;

    public ItemBlock(Block var0, Item.Info var1) {
        super(var1);
        this.block = var0;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        EnumInteractionResult var1 = this.place(new BlockActionContext(var0));
        if (!var1.consumesAction() && var0.getItemInHand().has(DataComponents.FOOD)) {
            EnumInteractionResult var2 = super.use(var0.getLevel(), var0.getPlayer(), var0.getHand()).getResult();
            return var2 == EnumInteractionResult.CONSUME ? EnumInteractionResult.CONSUME_PARTIAL : var2;
        }
        return var1;
    }

    public EnumInteractionResult place(BlockActionContext var0) {
        if (!this.getBlock().isEnabled(var0.getLevel().enabledFeatures())) {
            return EnumInteractionResult.FAIL;
        }
        if (!var0.canPlace()) {
            return EnumInteractionResult.FAIL;
        }
        BlockActionContext var1 = this.updatePlacementContext(var0);
        if (var1 == null) {
            return EnumInteractionResult.FAIL;
        }
        IBlockData var2 = this.getPlacementState(var1);
        if (var2 == null) {
            return EnumInteractionResult.FAIL;
        }
        if (!this.placeBlock(var1, var2)) {
            return EnumInteractionResult.FAIL;
        }
        BlockPosition var3 = var1.getClickedPos();
        World var4 = var1.getLevel();
        EntityHuman var5 = var1.getPlayer();
        ItemStack var6 = var1.getItemInHand();
        IBlockData var7 = var4.getBlockState(var3);
        if (var7.is(var2.getBlock())) {
            var7 = this.updateBlockStateFromTag(var3, var4, var6, var7);
            this.updateCustomBlockEntityTag(var3, var4, var5, var6, var7);
            ItemBlock.updateBlockEntityComponents(var4, var3, var6);
            var7.getBlock().setPlacedBy(var4, var3, var7, var5, var6);
            if (var5 instanceof EntityPlayer) {
                CriterionTriggers.PLACED_BLOCK.trigger((EntityPlayer)var5, var3, var6);
            }
        }
        SoundEffectType var8 = var7.getSoundType();
        var4.playSound(var5, var3, this.getPlaceSound(var7), SoundCategory.BLOCKS, (var8.getVolume() + 1.0f) / 2.0f, var8.getPitch() * 0.8f);
        var4.gameEvent(GameEvent.BLOCK_PLACE, var3, GameEvent.a.of(var5, var7));
        var6.consume(1, var5);
        return EnumInteractionResult.sidedSuccess(var4.isClientSide);
    }

    protected SoundEffect getPlaceSound(IBlockData var0) {
        return var0.getSoundType().getPlaceSound();
    }

    @Nullable
    public BlockActionContext updatePlacementContext(BlockActionContext var0) {
        return var0;
    }

    private static void updateBlockEntityComponents(World var0, BlockPosition var1, ItemStack var2) {
        TileEntity var3 = var0.getBlockEntity(var1);
        if (var3 != null) {
            var3.applyComponentsFromItemStack(var2);
            var3.setChanged();
        }
    }

    protected boolean updateCustomBlockEntityTag(BlockPosition var0, World var1, @Nullable EntityHuman var2, ItemStack var3, IBlockData var4) {
        return ItemBlock.updateCustomBlockEntityTag(var1, var2, var0, var3);
    }

    @Nullable
    protected IBlockData getPlacementState(BlockActionContext var0) {
        IBlockData var1 = this.getBlock().getStateForPlacement(var0);
        return var1 != null && this.canPlace(var0, var1) ? var1 : null;
    }

    private IBlockData updateBlockStateFromTag(BlockPosition var0, World var1, ItemStack var2, IBlockData var3) {
        BlockItemStateProperties var4 = var2.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY);
        if (var4.isEmpty()) {
            return var3;
        }
        IBlockData var5 = var4.apply(var3);
        if (var5 != var3) {
            var1.setBlock(var0, var5, 2);
        }
        return var5;
    }

    protected boolean canPlace(BlockActionContext var0, IBlockData var1) {
        EntityHuman var2 = var0.getPlayer();
        VoxelShapeCollision var3 = var2 == null ? VoxelShapeCollision.empty() : VoxelShapeCollision.of(var2);
        return (!this.mustSurvive() || var1.canSurvive(var0.getLevel(), var0.getClickedPos())) && var0.getLevel().isUnobstructed(var1, var0.getClickedPos(), var3);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockActionContext var0, IBlockData var1) {
        return var0.getLevel().setBlock(var0.getClickedPos(), var1, 11);
    }

    public static boolean updateCustomBlockEntityTag(World var0, @Nullable EntityHuman var1, BlockPosition var2, ItemStack var3) {
        TileEntity var6;
        MinecraftServer var4 = var0.getServer();
        if (var4 == null) {
            return false;
        }
        CustomData var5 = var3.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
        if (!var5.isEmpty() && (var6 = var0.getBlockEntity(var2)) != null) {
            if (!(var0.isClientSide || !var6.onlyOpCanSetNbt() || var1 != null && var1.canUseGameMasterBlocks())) {
                return false;
            }
            return var5.loadInto(var6, var0.registryAccess());
        }
        return false;
    }

    @Override
    public String getDescriptionId() {
        return this.getBlock().getDescriptionId();
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        this.getBlock().appendHoverText(var0, var1, var2, var3);
    }

    public Block getBlock() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> var0, Item var1) {
        var0.put(this.getBlock(), var1);
    }

    @Override
    public boolean canFitInsideContainerItems() {
        return !(this.getBlock() instanceof BlockShulkerBox);
    }

    @Override
    public void onDestroyed(EntityItem var0) {
        ItemContainerContents var1 = var0.getItem().set(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        if (var1 != null) {
            ItemLiquidUtil.onContainerDestroyed(var0, var1.nonEmptyItemsCopy());
        }
    }

    public static void setBlockEntityData(ItemStack var0, TileEntityTypes<?> var1, NBTTagCompound var2) {
        var2.remove("id");
        if (var2.isEmpty()) {
            var0.remove(DataComponents.BLOCK_ENTITY_DATA);
        } else {
            TileEntity.addEntityType(var2, var1);
            var0.set(DataComponents.BLOCK_ENTITY_DATA, CustomData.of(var2));
        }
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.getBlock().requiredFeatures();
    }
}

