/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.World;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    private static final int BAR_COLOR = MathHelper.color(0.4f, 0.4f, 1.0f);
    private static final int TOOLTIP_MAX_WEIGHT = 64;

    public BundleItem(Item.Info var0) {
        super(var0);
    }

    public static float getFullnessDisplay(ItemStack var0) {
        BundleContents var1 = var0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return var1.weight().floatValue();
    }

    @Override
    public boolean overrideStackedOnOther(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3) {
        int var7;
        if (var2 != ClickAction.SECONDARY) {
            return false;
        }
        BundleContents var4 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var4 == null) {
            return false;
        }
        ItemStack var5 = var1.getItem();
        BundleContents.a var6 = new BundleContents.a(var4);
        if (var5.isEmpty()) {
            this.playRemoveOneSound(var3);
            ItemStack var72 = var6.removeOne();
            if (var72 != null) {
                ItemStack var8 = var1.safeInsert(var72);
                var6.tryInsert(var8);
            }
        } else if (var5.getItem().canFitInsideContainerItems() && (var7 = var6.tryTransfer(var1, var3)) > 0) {
            this.playInsertSound(var3);
        }
        var0.set(DataComponents.BUNDLE_CONTENTS, var6.toImmutable());
        return true;
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack var0, ItemStack var1, Slot var2, ClickAction var3, EntityHuman var4, SlotAccess var5) {
        if (var3 != ClickAction.SECONDARY || !var2.allowModification(var4)) {
            return false;
        }
        BundleContents var6 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var6 == null) {
            return false;
        }
        BundleContents.a var7 = new BundleContents.a(var6);
        if (var1.isEmpty()) {
            ItemStack var8 = var7.removeOne();
            if (var8 != null) {
                this.playRemoveOneSound(var4);
                var5.set(var8);
            }
        } else {
            int var8 = var7.tryInsert(var1);
            if (var8 > 0) {
                this.playInsertSound(var4);
            }
        }
        var0.set(DataComponents.BUNDLE_CONTENTS, var7.toImmutable());
        return true;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (BundleItem.dropContents(var3, var1)) {
            this.playDropContentsSound(var1);
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
        }
        return InteractionResultWrapper.fail(var3);
    }

    @Override
    public boolean isBarVisible(ItemStack var0) {
        BundleContents var1 = var0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return var1.weight().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    public int getBarWidth(ItemStack var0) {
        BundleContents var1 = var0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return Math.min(1 + MathHelper.mulAndTruncate(var1.weight(), 12), 13);
    }

    @Override
    public int getBarColor(ItemStack var0) {
        return BAR_COLOR;
    }

    private static boolean dropContents(ItemStack var0, EntityHuman var12) {
        BundleContents var2 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var2 == null || var2.isEmpty()) {
            return false;
        }
        var0.set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        if (var12 instanceof EntityPlayer) {
            var2.itemsCopy().forEach(var1 -> var12.drop((ItemStack)var1, true));
        }
        return true;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack var0) {
        if (var0.has(DataComponents.HIDE_TOOLTIP) || var0.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return Optional.empty();
        }
        return Optional.ofNullable(var0.get(DataComponents.BUNDLE_CONTENTS)).map(BundleTooltip::new);
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        BundleContents var4 = var0.get(DataComponents.BUNDLE_CONTENTS);
        if (var4 != null) {
            int var5 = MathHelper.mulAndTruncate(var4.weight(), 64);
            var2.add(IChatBaseComponent.translatable("item.minecraft.bundle.fullness", var5, 64).withStyle(EnumChatFormat.GRAY));
        }
    }

    @Override
    public void onDestroyed(EntityItem var0) {
        BundleContents var1 = var0.getItem().get(DataComponents.BUNDLE_CONTENTS);
        if (var1 == null) {
            return;
        }
        var0.getItem().set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        ItemLiquidUtil.onContainerDestroyed(var0, var1.itemsCopy());
    }

    private void playRemoveOneSound(Entity var0) {
        var0.playSound(SoundEffects.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + var0.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity var0) {
        var0.playSound(SoundEffects.BUNDLE_INSERT, 0.8f, 0.8f + var0.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity var0) {
        var0.playSound(SoundEffects.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + var0.level().getRandom().nextFloat() * 0.4f);
    }
}

