/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3D;

public class ContainerGrindstone
extends Container {
    public static final int MAX_NAME_LENGTH = 35;
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final IInventory resultSlots = new InventoryCraftResult();
    final IInventory repairSlots = new InventorySubcontainer(2){

        @Override
        public void setChanged() {
            super.setChanged();
            ContainerGrindstone.this.slotsChanged(this);
        }
    };
    private final ContainerAccess access;

    public ContainerGrindstone(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerGrindstone(int var0, PlayerInventory var1, final ContainerAccess var2) {
        super(Containers.GRINDSTONE, var0);
        int var3;
        this.access = var2;
        this.addSlot(new Slot(this, this.repairSlots, 0, 49, 19){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.isDamageableItem() || EnchantmentManager.hasAnyEnchantments(var0);
            }
        });
        this.addSlot(new Slot(this, this.repairSlots, 1, 49, 40){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.isDamageableItem() || EnchantmentManager.hasAnyEnchantments(var0);
            }
        });
        this.addSlot(new Slot(this.resultSlots, 2, 129, 34){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return false;
            }

            @Override
            public void onTake(EntityHuman var02, ItemStack var12) {
                var2.execute((var0, var1) -> {
                    if (var0 instanceof WorldServer) {
                        EntityExperienceOrb.award((WorldServer)var0, Vec3D.atCenterOf(var1), this.getExperienceAmount((World)var0));
                    }
                    var0.levelEvent(1042, (BlockPosition)var1, 0);
                });
                ContainerGrindstone.this.repairSlots.setItem(0, ItemStack.EMPTY);
                ContainerGrindstone.this.repairSlots.setItem(1, ItemStack.EMPTY);
            }

            private int getExperienceAmount(World var0) {
                int var1 = 0;
                var1 += this.getExperienceFromItem(ContainerGrindstone.this.repairSlots.getItem(0));
                if ((var1 += this.getExperienceFromItem(ContainerGrindstone.this.repairSlots.getItem(1))) > 0) {
                    int var22 = (int)Math.ceil((double)var1 / 2.0);
                    return var22 + var0.random.nextInt(var22);
                }
                return 0;
            }

            private int getExperienceFromItem(ItemStack var0) {
                int var1 = 0;
                ItemEnchantments var22 = EnchantmentManager.getEnchantmentsForCrafting(var0);
                for (Object2IntMap.Entry<Holder<Enchantment>> var4 : var22.entrySet()) {
                    Enchantment var5 = (Enchantment)((Holder)var4.getKey()).value();
                    int var6 = var4.getIntValue();
                    if (var5.isCurse()) continue;
                    var1 += var5.getMinCost(var6);
                }
                return var1;
            }
        });
        for (var3 = 0; var3 < 3; ++var3) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.addSlot(new Slot(var1, var4 + var3 * 9 + 9, 8 + var4 * 18, 84 + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 9; ++var3) {
            this.addSlot(new Slot(var1, var3, 8 + var3 * 18, 142));
        }
    }

    @Override
    public void slotsChanged(IInventory var0) {
        super.slotsChanged(var0);
        if (var0 == this.repairSlots) {
            this.createResult();
        }
    }

    private void createResult() {
        this.resultSlots.setItem(0, this.computeResult(this.repairSlots.getItem(0), this.repairSlots.getItem(1)));
        this.broadcastChanges();
    }

    private ItemStack computeResult(ItemStack var0, ItemStack var1) {
        boolean var3;
        boolean var2;
        boolean bl = var2 = !var0.isEmpty() || !var1.isEmpty();
        if (!var2) {
            return ItemStack.EMPTY;
        }
        if (var0.getCount() > 1 || var1.getCount() > 1) {
            return ItemStack.EMPTY;
        }
        boolean bl2 = var3 = !var0.isEmpty() && !var1.isEmpty();
        if (!var3) {
            ItemStack var4;
            ItemStack itemStack = var4 = !var0.isEmpty() ? var0 : var1;
            if (!EnchantmentManager.hasAnyEnchantments(var4)) {
                return ItemStack.EMPTY;
            }
            return this.removeNonCursesFrom(var4.copy());
        }
        return this.mergeItems(var0, var1);
    }

    private ItemStack mergeItems(ItemStack var0, ItemStack var1) {
        ItemStack var7;
        if (!var0.is(var1.getItem())) {
            return ItemStack.EMPTY;
        }
        int var2 = Math.max(var0.getMaxDamage(), var1.getMaxDamage());
        int var3 = var0.getMaxDamage() - var0.getDamageValue();
        int var4 = var1.getMaxDamage() - var1.getDamageValue();
        int var5 = var3 + var4 + var2 * 5 / 100;
        int var6 = 1;
        if (!var0.isDamageableItem()) {
            if (var0.getMaxStackSize() < 2 || !ItemStack.matches(var0, var1)) {
                return ItemStack.EMPTY;
            }
            var6 = 2;
        }
        if ((var7 = var0.copyWithCount(var6)).isDamageableItem()) {
            var7.set(DataComponents.MAX_DAMAGE, var2);
            var7.setDamageValue(Math.max(var2 - var5, 0));
        }
        this.mergeEnchantsFrom(var7, var1);
        return this.removeNonCursesFrom(var7);
    }

    private void mergeEnchantsFrom(ItemStack var0, ItemStack var12) {
        EnchantmentManager.updateEnchantments(var0, var1 -> {
            ItemEnchantments var2 = EnchantmentManager.getEnchantmentsForCrafting(var12);
            for (Object2IntMap.Entry<Holder<Enchantment>> var4 : var2.entrySet()) {
                Enchantment var5 = (Enchantment)((Holder)var4.getKey()).value();
                if (var5.isCurse() && var1.getLevel(var5) != 0) continue;
                var1.upgrade(var5, var4.getIntValue());
            }
        });
    }

    private ItemStack removeNonCursesFrom(ItemStack var0) {
        ItemEnchantments var1 = EnchantmentManager.updateEnchantments(var0, var02 -> var02.removeIf(var0 -> !((Enchantment)var0.value()).isCurse()));
        if (var0.is(Items.ENCHANTED_BOOK) && var1.isEmpty()) {
            var0 = var0.transmuteCopy(Items.BOOK, var0.getCount());
        }
        int var2 = 0;
        for (int var3 = 0; var3 < var1.size(); ++var3) {
            var2 = ContainerAnvil.calculateIncreasedRepairCost(var2);
        }
        var0.set(DataComponents.REPAIR_COST, var2);
        return var0;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.repairSlots));
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return ContainerGrindstone.stillValid(this.access, var0, Blocks.GRINDSTONE);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            ItemStack var5 = this.repairSlots.getItem(0);
            ItemStack var6 = this.repairSlots.getItem(1);
            if (var1 == 2) {
                if (!this.moveItemStackTo(var4, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 == 0 || var1 == 1 ? !this.moveItemStackTo(var4, 3, 39, false) : (var5.isEmpty() || var6.isEmpty() ? !this.moveItemStackTo(var4, 0, 2, false) : (var1 >= 3 && var1 < 30 ? !this.moveItemStackTo(var4, 30, 39, false) : var1 >= 30 && var1 < 39 && !this.moveItemStackTo(var4, 3, 30, false)))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }
}

