/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvilAbstract;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class ContainerAnvil
extends ContainerAnvilAbstract {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG_COST = false;
    public static final int MAX_NAME_LENGTH = 50;
    public int repairItemCountCost;
    @Nullable
    public String itemName;
    public final ContainerProperty cost = ContainerProperty.standalone();
    private static final int COST_FAIL = 0;
    private static final int COST_BASE = 1;
    private static final int COST_ADDED_BASE = 1;
    private static final int COST_REPAIR_MATERIAL = 1;
    private static final int COST_REPAIR_SACRIFICE = 2;
    private static final int COST_INCOMPATIBLE_PENALTY = 1;
    private static final int COST_RENAME = 1;
    private static final int INPUT_SLOT_X_PLACEMENT = 27;
    private static final int ADDITIONAL_SLOT_X_PLACEMENT = 76;
    private static final int RESULT_SLOT_X_PLACEMENT = 134;
    private static final int SLOT_Y_PLACEMENT = 47;

    public ContainerAnvil(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerAnvil(int var0, PlayerInventory var1, ContainerAccess var2) {
        super(Containers.ANVIL, var0, var1, var2);
        this.addDataSlot(this.cost);
    }

    @Override
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, var0 -> true).withSlot(1, 76, 47, var0 -> true).withResultSlot(2, 134, 47).build();
    }

    @Override
    protected boolean isValidBlock(IBlockData var0) {
        return var0.is(TagsBlock.ANVIL);
    }

    @Override
    protected boolean mayPickup(EntityHuman var0, boolean var1) {
        return (var0.hasInfiniteMaterials() || var0.experienceLevel >= this.cost.get()) && this.cost.get() > 0;
    }

    @Override
    protected void onTake(EntityHuman var0, ItemStack var12) {
        if (!var0.getAbilities().instabuild) {
            var0.giveExperienceLevels(-this.cost.get());
        }
        this.inputSlots.setItem(0, ItemStack.EMPTY);
        if (this.repairItemCountCost > 0) {
            ItemStack var22 = this.inputSlots.getItem(1);
            if (!var22.isEmpty() && var22.getCount() > this.repairItemCountCost) {
                var22.shrink(this.repairItemCountCost);
                this.inputSlots.setItem(1, var22);
            } else {
                this.inputSlots.setItem(1, ItemStack.EMPTY);
            }
        } else {
            this.inputSlots.setItem(1, ItemStack.EMPTY);
        }
        this.cost.set(0);
        this.access.execute((var1, var2) -> {
            IBlockData var3 = var1.getBlockState((BlockPosition)var2);
            if (!var0.hasInfiniteMaterials() && var3.is(TagsBlock.ANVIL) && var0.getRandom().nextFloat() < 0.12f) {
                IBlockData var4 = BlockAnvil.damage(var3);
                if (var4 == null) {
                    var1.removeBlock((BlockPosition)var2, false);
                    var1.levelEvent(1029, (BlockPosition)var2, 0);
                } else {
                    var1.setBlock((BlockPosition)var2, var4, 2);
                    var1.levelEvent(1030, (BlockPosition)var2, 0);
                }
            } else {
                var1.levelEvent(1030, (BlockPosition)var2, 0);
            }
        });
    }

    @Override
    public void createResult() {
        int var9;
        int var8;
        ItemStack var0 = this.inputSlots.getItem(0);
        this.cost.set(1);
        int var1 = 0;
        long var2 = 0L;
        int var4 = 0;
        if (var0.isEmpty() || !EnchantmentManager.canStoreEnchantments(var0)) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
            this.cost.set(0);
            return;
        }
        ItemStack var5 = var0.copy();
        ItemStack var6 = this.inputSlots.getItem(1);
        ItemEnchantments.a var7 = new ItemEnchantments.a(EnchantmentManager.getEnchantmentsForCrafting(var5));
        var2 += (long)var0.getOrDefault(DataComponents.REPAIR_COST, 0).intValue() + (long)var6.getOrDefault(DataComponents.REPAIR_COST, 0).intValue();
        this.repairItemCountCost = 0;
        if (!var6.isEmpty()) {
            var8 = var6.has(DataComponents.STORED_ENCHANTMENTS);
            if (var5.isDamageableItem() && var5.getItem().isValidRepairItem(var0, var6)) {
                int var10;
                var9 = Math.min(var5.getDamageValue(), var5.getMaxDamage() / 4);
                if (var9 <= 0) {
                    this.resultSlots.setItem(0, ItemStack.EMPTY);
                    this.cost.set(0);
                    return;
                }
                for (var10 = 0; var9 > 0 && var10 < var6.getCount(); ++var10) {
                    int var11 = var5.getDamageValue() - var9;
                    var5.setDamageValue(var11);
                    ++var1;
                    var9 = Math.min(var5.getDamageValue(), var5.getMaxDamage() / 4);
                }
                this.repairItemCountCost = var10;
            } else {
                int var11;
                int var10;
                if (!(var8 != 0 || var5.is(var6.getItem()) && var5.isDamageableItem())) {
                    this.resultSlots.setItem(0, ItemStack.EMPTY);
                    this.cost.set(0);
                    return;
                }
                if (var5.isDamageableItem() && var8 == 0) {
                    int var92 = var0.getMaxDamage() - var0.getDamageValue();
                    var10 = var6.getMaxDamage() - var6.getDamageValue();
                    var11 = var10 + var5.getMaxDamage() * 12 / 100;
                    int var12 = var92 + var11;
                    int var13 = var5.getMaxDamage() - var12;
                    if (var13 < 0) {
                        var13 = 0;
                    }
                    if (var13 < var5.getDamageValue()) {
                        var5.setDamageValue(var13);
                        var1 += 2;
                    }
                }
                ItemEnchantments var93 = EnchantmentManager.getEnchantmentsForCrafting(var6);
                var10 = 0;
                var11 = 0;
                for (Object2IntMap.Entry<Holder<Enchantment>> var13 : var93.entrySet()) {
                    int var17;
                    Holder var14 = (Holder)var13.getKey();
                    Enchantment var15 = (Enchantment)var14.value();
                    int var16 = var7.getLevel(var15);
                    var17 = var16 == (var17 = var13.getIntValue()) ? var17 + 1 : Math.max(var17, var16);
                    boolean var18 = var15.canEnchant(var0);
                    if (this.player.getAbilities().instabuild || var0.is(Items.ENCHANTED_BOOK)) {
                        var18 = true;
                    }
                    for (Holder<Enchantment> var20 : var7.keySet()) {
                        if (var20.equals(var14) || var15.isCompatibleWith(var20.value())) continue;
                        var18 = false;
                        ++var1;
                    }
                    if (!var18) {
                        var11 = 1;
                        continue;
                    }
                    var10 = 1;
                    if (var17 > var15.getMaxLevel()) {
                        var17 = var15.getMaxLevel();
                    }
                    var7.set(var15, var17);
                    int var19 = var15.getAnvilCost();
                    if (var8 != 0) {
                        var19 = Math.max(1, var19 / 2);
                    }
                    var1 += var19 * var17;
                    if (var0.getCount() <= 1) continue;
                    var1 = 40;
                }
                if (var11 != 0 && var10 == 0) {
                    this.resultSlots.setItem(0, ItemStack.EMPTY);
                    this.cost.set(0);
                    return;
                }
            }
        }
        if (this.itemName == null || UtilColor.isBlank(this.itemName)) {
            if (var0.has(DataComponents.CUSTOM_NAME)) {
                var4 = 1;
                var1 += var4;
                var5.remove(DataComponents.CUSTOM_NAME);
            }
        } else if (!this.itemName.equals(var0.getHoverName().getString())) {
            var4 = 1;
            var1 += var4;
            var5.set(DataComponents.CUSTOM_NAME, IChatBaseComponent.literal(this.itemName));
        }
        var8 = (int)MathHelper.clamp(var2 + (long)var1, 0L, Integer.MAX_VALUE);
        this.cost.set(var8);
        if (var1 <= 0) {
            var5 = ItemStack.EMPTY;
        }
        if (var4 == var1 && var4 > 0 && this.cost.get() >= 40) {
            this.cost.set(39);
        }
        if (this.cost.get() >= 40 && !this.player.getAbilities().instabuild) {
            var5 = ItemStack.EMPTY;
        }
        if (!var5.isEmpty()) {
            var9 = var5.getOrDefault(DataComponents.REPAIR_COST, 0);
            if (var9 < var6.getOrDefault(DataComponents.REPAIR_COST, 0)) {
                var9 = var6.getOrDefault(DataComponents.REPAIR_COST, 0);
            }
            if (var4 != var1 || var4 == 0) {
                var9 = ContainerAnvil.calculateIncreasedRepairCost(var9);
            }
            var5.set(DataComponents.REPAIR_COST, var9);
            EnchantmentManager.setEnchantments(var5, var7.toImmutable());
        }
        this.resultSlots.setItem(0, var5);
        this.broadcastChanges();
    }

    public static int calculateIncreasedRepairCost(int var0) {
        return (int)Math.min((long)var0 * 2L + 1L, Integer.MAX_VALUE);
    }

    public boolean setItemName(String var0) {
        String var1 = ContainerAnvil.validateName(var0);
        if (var1 == null || var1.equals(this.itemName)) {
            return false;
        }
        this.itemName = var1;
        if (this.getSlot(2).hasItem()) {
            ItemStack var2 = this.getSlot(2).getItem();
            if (UtilColor.isBlank(var1)) {
                var2.remove(DataComponents.CUSTOM_NAME);
            } else {
                var2.set(DataComponents.CUSTOM_NAME, IChatBaseComponent.literal(var1));
            }
        }
        this.createResult();
        return true;
    }

    @Nullable
    private static String validateName(String var0) {
        String var1 = UtilColor.filterText(var0);
        if (var1.length() <= 50) {
            return var1;
        }
        return null;
    }

    public int getCost() {
        return this.cost.get();
    }
}

