/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public abstract class VehicleEntity
extends Entity {
    protected static final DataWatcherObject<Integer> DATA_ID_HURT = DataWatcher.defineId(VehicleEntity.class, DataWatcherRegistry.INT);
    protected static final DataWatcherObject<Integer> DATA_ID_HURTDIR = DataWatcher.defineId(VehicleEntity.class, DataWatcherRegistry.INT);
    protected static final DataWatcherObject<Float> DATA_ID_DAMAGE = DataWatcher.defineId(VehicleEntity.class, DataWatcherRegistry.FLOAT);

    public VehicleEntity(EntityTypes<?> var0, World var1) {
        super(var0, var1);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        boolean var2;
        if (this.level().isClientSide || this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.markHurt();
        this.setDamage(this.getDamage() + var1 * 10.0f);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, var0.getEntity());
        boolean bl = var2 = var0.getEntity() instanceof EntityHuman && ((EntityHuman)var0.getEntity()).getAbilities().instabuild;
        if (!var2 && this.getDamage() > 40.0f || this.shouldSourceDestroy(var0)) {
            this.destroy(var0);
        } else if (var2) {
            this.discard();
        }
        return true;
    }

    boolean shouldSourceDestroy(DamageSource var0) {
        return false;
    }

    public void destroy(Item var0) {
        this.kill();
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        ItemStack var1 = new ItemStack(var0);
        var1.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        this.spawnAtLocation(var1);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ID_HURT, 0);
        var0.define(DATA_ID_HURTDIR, 1);
        var0.define(DATA_ID_DAMAGE, Float.valueOf(0.0f));
    }

    public void setHurtTime(int var0) {
        this.entityData.set(DATA_ID_HURT, var0);
    }

    public void setHurtDir(int var0) {
        this.entityData.set(DATA_ID_HURTDIR, var0);
    }

    public void setDamage(float var0) {
        this.entityData.set(DATA_ID_DAMAGE, Float.valueOf(var0));
    }

    public float getDamage() {
        return this.entityData.get(DATA_ID_DAMAGE).floatValue();
    }

    public int getHurtTime() {
        return this.entityData.get(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return this.entityData.get(DATA_ID_HURTDIR);
    }

    protected void destroy(DamageSource var0) {
        this.destroy(this.getDropItem());
    }

    abstract Item getDropItem();
}

