/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.windcharge;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public abstract class AbstractWindCharge
extends EntityFireball
implements ItemSupplier {
    public static final a EXPLOSION_DAMAGE_CALCULATOR = new a();

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> var0, World var1) {
        super((EntityTypes<? extends EntityFireball>)var0, var1);
    }

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> var0, World var1, Entity var2, double var3, double var5, double var7) {
        super(var0, var3, var5, var7, var1);
        this.setOwner(var2);
    }

    AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> var0, double var1, double var3, double var5, double var7, double var9, double var11, World var13) {
        super(var0, var1, var3, var5, var7, var9, var11, var13);
    }

    @Override
    protected AxisAlignedBB makeBoundingBox() {
        float var0 = this.getType().getDimensions().width() / 2.0f;
        float var1 = this.getType().getDimensions().height();
        float var2 = 0.15f;
        return new AxisAlignedBB(this.position().x - (double)var0, this.position().y - (double)0.15f, this.position().z - (double)var0, this.position().x + (double)var0, this.position().y - (double)0.15f + (double)var1, this.position().z + (double)var0);
    }

    @Override
    public boolean canCollideWith(Entity var0) {
        if (var0 instanceof AbstractWindCharge) {
            return false;
        }
        return super.canCollideWith(var0);
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        if (var0 instanceof AbstractWindCharge) {
            return false;
        }
        if (var0.getType() == EntityTypes.END_CRYSTAL) {
            return false;
        }
        return super.canHitEntity(var0);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        EntityLiving entityLiving;
        Entity var2;
        super.onHitEntity(var0);
        if (this.level().isClientSide) {
            return;
        }
        Entity entity = this.getOwner();
        if (entity instanceof EntityLiving) {
            var2 = (EntityLiving)entity;
            entityLiving = var2;
        } else {
            entityLiving = null;
        }
        EntityLiving var1 = entityLiving;
        var2 = var0.getEntity().getPassengerClosestTo(var0.getLocation()).orElse(var0.getEntity());
        if (var1 != null) {
            var1.setLastHurtMob(var2);
        }
        var2.hurt(this.damageSources().windCharge(this, var1), 1.0f);
        this.explode();
    }

    @Override
    public void push(double var0, double var2, double var4) {
    }

    public abstract void explode();

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        if (!this.level().isClientSide) {
            this.explode();
            this.discard();
        }
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    @Override
    protected float getLiquidInertia() {
        return this.getInertia();
    }

    @Override
    @Nullable
    protected ParticleParam getTrailParticle() {
        return null;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.getBlockY() > this.level().getMaxBuildHeight() + 30) {
            this.explode();
            this.discard();
        } else {
            super.tick();
        }
    }

    public static class a
    extends ExplosionDamageCalculator {
        @Override
        public boolean shouldDamageEntity(Explosion var0, Entity var1) {
            return false;
        }

        @Override
        public Optional<Float> getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, Fluid var4) {
            if (var3.is(TagsBlock.BLOCKS_WIND_CHARGE_EXPLOSIONS)) {
                return Optional.of(Float.valueOf(3600000.0f));
            }
            return Optional.empty();
        }
    }
}

