/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityFireball
extends IProjectile {
    public static final double ATTACK_DEFLECTION_SCALE = 0.1;
    public static final double BOUNCE_DEFLECTION_SCALE = 0.05;
    public double xPower;
    public double yPower;
    public double zPower;

    protected EntityFireball(EntityTypes<? extends EntityFireball> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    protected EntityFireball(EntityTypes<? extends EntityFireball> var0, double var1, double var3, double var5, World var7) {
        this(var0, var7);
        this.setPos(var1, var3, var5);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> var0, double var1, double var3, double var5, double var7, double var9, double var11, World var13) {
        this(var0, var13);
        this.moveTo(var1, var3, var5, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.assignPower(var7, var9, var11);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> var0, EntityLiving var1, double var2, double var4, double var6, World var8) {
        this(var0, var1.getX(), var1.getY(), var1.getZ(), var2, var4, var6, var8);
        this.setOwner(var1);
        this.setRot(var1.getYRot(), var1.getXRot());
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(var2)) {
            var2 = 4.0;
        }
        return var0 < (var2 *= 64.0) * var2;
    }

    protected RayTrace.BlockCollisionOption getClipType() {
        return RayTrace.BlockCollisionOption.COLLIDER;
    }

    @Override
    public void tick() {
        float var9;
        MovingObjectPosition var1;
        Entity var0 = this.getOwner();
        if (!this.level().isClientSide && (var0 != null && var0.isRemoved() || !this.level().hasChunkAt(this.blockPosition()))) {
            this.discard();
            return;
        }
        super.tick();
        if (this.shouldBurn()) {
            this.igniteForSeconds(1);
        }
        if ((var1 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity, this.getClipType())).getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
            this.hitTargetOrDeflectSelf(var1);
        }
        this.checkInsideBlocks();
        Vec3D var2 = this.getDeltaMovement();
        double var3 = this.getX() + var2.x;
        double var5 = this.getY() + var2.y;
        double var7 = this.getZ() + var2.z;
        ProjectileHelper.rotateTowardsMovement(this, 0.2f);
        if (this.isInWater()) {
            for (int var10 = 0; var10 < 4; ++var10) {
                float var11 = 0.25f;
                this.level().addParticle(Particles.BUBBLE, var3 - var2.x * 0.25, var5 - var2.y * 0.25, var7 - var2.z * 0.25, var2.x, var2.y, var2.z);
            }
            var9 = this.getLiquidInertia();
        } else {
            var9 = this.getInertia();
        }
        this.setDeltaMovement(var2.add(this.xPower, this.yPower, this.zPower).scale(var9));
        ParticleParam var10 = this.getTrailParticle();
        if (var10 != null) {
            this.level().addParticle(var10, var3, var5 + 0.5, var7, 0.0, 0.0, 0.0);
        }
        this.setPos(var3, var5, var7);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        return !this.isInvulnerableTo(var0);
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        return super.canHitEntity(var0) && !var0.noPhysics;
    }

    protected boolean shouldBurn() {
        return true;
    }

    @Nullable
    protected ParticleParam getTrailParticle() {
        return Particles.SMOKE;
    }

    protected float getInertia() {
        return 0.95f;
    }

    protected float getLiquidInertia() {
        return 0.8f;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.put("power", this.newDoubleList(this.xPower, this.yPower, this.zPower));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        NBTTagList var1;
        super.readAdditionalSaveData(var0);
        if (var0.contains("power", 9) && (var1 = var0.getList("power", 6)).size() == 3) {
            this.xPower = var1.getDouble(0);
            this.yPower = var1.getDouble(1);
            this.zPower = var1.getDouble(2);
        }
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket() {
        Entity var0 = this.getOwner();
        int var1 = var0 == null ? 0 : var0.getId();
        return new PacketPlayOutSpawnEntity(this.getId(), this.getUUID(), this.getX(), this.getY(), this.getZ(), this.getXRot(), this.getYRot(), this.getType(), var1, new Vec3D(this.xPower, this.yPower, this.zPower), 0.0);
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        double var1 = var0.getXa();
        double var3 = var0.getYa();
        double var5 = var0.getZa();
        this.assignPower(var1, var3, var5);
    }

    public void assignPower(double var0, double var2, double var4) {
        double var6 = Math.sqrt(var0 * var0 + var2 * var2 + var4 * var4);
        if (var6 != 0.0) {
            this.xPower = var0 / var6 * 0.1;
            this.yPower = var2 / var6 * 0.1;
            this.zPower = var4 / var6 * 0.1;
        }
    }

    @Override
    protected void onDeflection(@Nullable Entity var0, boolean var1) {
        super.onDeflection(var0, var1);
        if (var1) {
            this.xPower = this.getDeltaMovement().x * 0.1;
            this.yPower = this.getDeltaMovement().y * 0.1;
            this.zPower = this.getDeltaMovement().z * 0.1;
        } else {
            this.xPower = this.getDeltaMovement().x * 0.05;
            this.yPower = this.getDeltaMovement().y * 0.05;
            this.zPower = this.getDeltaMovement().z * 0.05;
        }
    }
}

