/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.15f, AttributeModifier.Operation.ADD_VALUE);
    private static final int DELAY_BETWEEN_CREEPY_STARE_SOUND = 400;
    private static final int MIN_DEAGGRESSION_TIME = 600;
    private static final DataWatcherObject<Optional<IBlockData>> DATA_CARRY_STATE = DataWatcher.defineId(EntityEnderman.class, DataWatcherRegistry.OPTIONAL_BLOCK_STATE);
    private static final DataWatcherObject<Boolean> DATA_CREEPY = DataWatcher.defineId(EntityEnderman.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_STARED_AT = DataWatcher.defineId(EntityEnderman.class, DataWatcherRegistry.BOOLEAN);
    private int lastStareSound = Integer.MIN_VALUE;
    private int targetChangeTime;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeRange.rangeOfSeconds(20, 39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new a(this));
        this.goalSelector.addGoal(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.goalSelector.addGoal(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.goalSelector.addGoal(11, new PathfinderGoalEndermanPickupBlock(this));
        this.targetSelector.addGoal(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::isAngryAt));
        this.targetSelector.addGoal(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.targetSelector.addGoal(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 40.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.ATTACK_DAMAGE, 7.0).add(GenericAttributes.FOLLOW_RANGE, 64.0).add(GenericAttributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public void setTarget(@Nullable EntityLiving var0) {
        super.setTarget(var0);
        AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        if (var0 == null) {
            this.targetChangeTime = 0;
            this.entityData.set(DATA_CREEPY, false);
            this.entityData.set(DATA_STARED_AT, false);
            var1.removeModifier(SPEED_MODIFIER_ATTACKING.id());
        } else {
            this.targetChangeTime = this.tickCount;
            this.entityData.set(DATA_CREEPY, true);
            if (!var1.hasModifier(SPEED_MODIFIER_ATTACKING)) {
                var1.addTransientModifier(SPEED_MODIFIER_ATTACKING);
            }
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_CARRY_STATE, Optional.empty());
        var0.define(DATA_CREEPY, false);
        var0.define(DATA_STARED_AT, false);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public void setRemainingPersistentAngerTime(int var0) {
        this.remainingPersistentAngerTime = var0;
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID var0) {
        this.persistentAngerTarget = var0;
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void playStareSound() {
        if (this.tickCount >= this.lastStareSound + 400) {
            this.lastStareSound = this.tickCount;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEffects.ENDERMAN_STARE, this.getSoundSource(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_CREEPY.equals(var0) && this.hasBeenStaredAt() && this.level().isClientSide) {
            this.playStareSound();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        IBlockData var1 = this.getCarriedBlock();
        if (var1 != null) {
            var0.put("carriedBlockState", GameProfileSerializer.writeBlockState(var1));
        }
        this.addPersistentAngerSaveData(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        IBlockData var1 = null;
        if (var0.contains("carriedBlockState", 10) && (var1 = GameProfileSerializer.readBlockState(this.level().holderLookup(Registries.BLOCK), var0.getCompound("carriedBlockState"))).isAir()) {
            var1 = null;
        }
        this.setCarriedBlock(var1);
        this.readPersistentAngerSaveData(this.level(), var0);
    }

    boolean isLookingAtMe(EntityHuman var0) {
        ItemStack var1 = var0.getInventory().armor.get(3);
        if (var1.is(Blocks.CARVED_PUMPKIN.asItem())) {
            return false;
        }
        Vec3D var2 = var0.getViewVector(1.0f).normalize();
        Vec3D var3 = new Vec3D(this.getX() - var0.getX(), this.getEyeY() - var0.getEyeY(), this.getZ() - var0.getZ());
        double var4 = var3.length();
        double var6 = var2.dot(var3 = var3.normalize());
        if (var6 > 1.0 - 0.025 / var4) {
            return var0.hasLineOfSight(this);
        }
        return false;
    }

    @Override
    public void aiStep() {
        if (this.level().isClientSide) {
            for (int var0 = 0; var0 < 2; ++var0) {
                this.level().addParticle(Particles.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        this.jumping = false;
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((WorldServer)this.level(), true);
        }
        super.aiStep();
    }

    @Override
    public boolean isSensitiveToWater() {
        return true;
    }

    @Override
    protected void customServerAiStep() {
        float var0;
        if (this.level().isDay() && this.tickCount >= this.targetChangeTime + 600 && (var0 = this.getLightLevelDependentMagicValue()) > 0.5f && this.level().canSeeSky(this.blockPosition()) && this.random.nextFloat() * 30.0f < (var0 - 0.4f) * 2.0f) {
            this.setTarget(null);
            this.teleport();
        }
        super.customServerAiStep();
    }

    public boolean teleport() {
        if (this.level().isClientSide() || !this.isAlive()) {
            return false;
        }
        double var0 = this.getX() + (this.random.nextDouble() - 0.5) * 64.0;
        double var2 = this.getY() + (double)(this.random.nextInt(64) - 32);
        double var4 = this.getZ() + (this.random.nextDouble() - 0.5) * 64.0;
        return this.teleport(var0, var2, var4);
    }

    public boolean teleportTowards(Entity var0) {
        Vec3D var1 = new Vec3D(this.getX() - var0.getX(), this.getY(0.5) - var0.getEyeY(), this.getZ() - var0.getZ());
        var1 = var1.normalize();
        double var2 = 16.0;
        double var4 = this.getX() + (this.random.nextDouble() - 0.5) * 8.0 - var1.x * 16.0;
        double var6 = this.getY() + (double)(this.random.nextInt(16) - 8) - var1.y * 16.0;
        double var8 = this.getZ() + (this.random.nextDouble() - 0.5) * 8.0 - var1.z * 16.0;
        return this.teleport(var4, var6, var8);
    }

    private boolean teleport(double var0, double var2, double var4) {
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition(var0, var2, var4);
        while (var6.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState(var6).blocksMotion()) {
            var6.move(EnumDirection.DOWN);
        }
        IBlockData var7 = this.level().getBlockState(var6);
        boolean var8 = var7.blocksMotion();
        boolean var9 = var7.getFluidState().is(TagsFluid.WATER);
        if (!var8 || var9) {
            return false;
        }
        Vec3D var10 = this.position();
        boolean var11 = this.randomTeleport(var0, var2, var4, true);
        if (var11) {
            this.level().gameEvent(GameEvent.TELEPORT, var10, GameEvent.a.of(this));
            if (!this.isSilent()) {
                this.level().playSound(null, this.xo, this.yo, this.zo, SoundEffects.ENDERMAN_TELEPORT, this.getSoundSource(), 1.0f, 1.0f);
                this.playSound(SoundEffects.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
        }
        return var11;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return this.isCreepy() ? SoundEffects.ENDERMAN_SCREAM : SoundEffects.ENDERMAN_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ENDERMAN_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ENDERMAN_DEATH;
    }

    @Override
    protected void dropCustomDeathLoot(DamageSource var0, int var1, boolean var2) {
        super.dropCustomDeathLoot(var0, var1, var2);
        IBlockData var3 = this.getCarriedBlock();
        if (var3 != null) {
            ItemStack var4 = new ItemStack(Items.DIAMOND_AXE);
            var4.enchant(Enchantments.SILK_TOUCH, 1);
            LootParams.a var5 = new LootParams.a((WorldServer)this.level()).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.TOOL, var4).withOptionalParameter(LootContextParameters.THIS_ENTITY, this);
            List<ItemStack> var6 = var3.getDrops(var5);
            for (ItemStack var8 : var6) {
                this.spawnAtLocation(var8);
            }
        }
    }

    public void setCarriedBlock(@Nullable IBlockData var0) {
        this.entityData.set(DATA_CARRY_STATE, Optional.ofNullable(var0));
    }

    @Nullable
    public IBlockData getCarriedBlock() {
        return this.entityData.get(DATA_CARRY_STATE).orElse(null);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        boolean var2 = var0.getDirectEntity() instanceof EntityPotion;
        if (var0.is(DamageTypeTags.IS_PROJECTILE) || var2) {
            boolean var3 = var2 && this.hurtWithCleanWater(var0, (EntityPotion)var0.getDirectEntity(), var1);
            for (int var4 = 0; var4 < 64; ++var4) {
                if (!this.teleport()) continue;
                return true;
            }
            return var3;
        }
        boolean var3 = super.hurt(var0, var1);
        if (!this.level().isClientSide() && !(var0.getEntity() instanceof EntityLiving) && this.random.nextInt(10) != 0) {
            this.teleport();
        }
        return var3;
    }

    private boolean hurtWithCleanWater(DamageSource var0, EntityPotion var1, float var2) {
        ItemStack var3 = var1.getItem();
        PotionContents var4 = var3.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if (var4.is(Potions.WATER)) {
            return super.hurt(var0, var2);
        }
        return false;
    }

    public boolean isCreepy() {
        return this.entityData.get(DATA_CREEPY);
    }

    public boolean hasBeenStaredAt() {
        return this.entityData.get(DATA_STARED_AT);
    }

    public void setBeingStaredAt() {
        this.entityData.set(DATA_STARED_AT, true);
    }

    @Override
    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.getCarriedBlock() != null;
    }

    static class a
    extends PathfinderGoal {
        private final EntityEnderman enderman;
        @Nullable
        private EntityLiving target;

        public a(EntityEnderman var0) {
            this.enderman = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.JUMP, PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            this.target = this.enderman.getTarget();
            if (!(this.target instanceof EntityHuman)) {
                return false;
            }
            double var0 = this.target.distanceToSqr(this.enderman);
            if (var0 > 256.0) {
                return false;
            }
            return this.enderman.isLookingAtMe((EntityHuman)this.target);
        }

        @Override
        public void start() {
            this.enderman.getNavigation().stop();
        }

        @Override
        public void tick() {
            this.enderman.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        }
    }

    static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman enderman;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman var0) {
            this.enderman = var0;
        }

        @Override
        public boolean canUse() {
            if (this.enderman.getCarriedBlock() == null) {
                return false;
            }
            if (!this.enderman.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return false;
            }
            return this.enderman.getRandom().nextInt(PathfinderGoalEndermanPlaceBlock.reducedTickDelay(2000)) == 0;
        }

        @Override
        public void tick() {
            RandomSource var0 = this.enderman.getRandom();
            World var1 = this.enderman.level();
            int var2 = MathHelper.floor(this.enderman.getX() - 1.0 + var0.nextDouble() * 2.0);
            int var3 = MathHelper.floor(this.enderman.getY() + var0.nextDouble() * 2.0);
            int var4 = MathHelper.floor(this.enderman.getZ() - 1.0 + var0.nextDouble() * 2.0);
            BlockPosition var5 = new BlockPosition(var2, var3, var4);
            IBlockData var6 = var1.getBlockState(var5);
            BlockPosition var7 = var5.below();
            IBlockData var8 = var1.getBlockState(var7);
            IBlockData var9 = this.enderman.getCarriedBlock();
            if (var9 == null) {
                return;
            }
            if (this.canPlaceBlock(var1, var5, var9 = Block.updateFromNeighbourShapes(var9, this.enderman.level(), var5), var6, var8, var7)) {
                var1.setBlock(var5, var9, 3);
                var1.gameEvent(GameEvent.BLOCK_PLACE, var5, GameEvent.a.of(this.enderman, var9));
                this.enderman.setCarriedBlock(null);
            }
        }

        private boolean canPlaceBlock(World var0, BlockPosition var1, IBlockData var2, IBlockData var3, IBlockData var4, BlockPosition var5) {
            return var3.isAir() && !var4.isAir() && !var4.is(Blocks.BEDROCK) && var4.isCollisionShapeFullBlock(var0, var5) && var2.canSurvive(var0, var1) && var0.getEntities(this.enderman, AxisAlignedBB.unitCubeFromLowerCorner(Vec3D.atLowerCornerOf(var1))).isEmpty();
        }
    }

    static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman enderman;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman var0) {
            this.enderman = var0;
        }

        @Override
        public boolean canUse() {
            if (this.enderman.getCarriedBlock() != null) {
                return false;
            }
            if (!this.enderman.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return false;
            }
            return this.enderman.getRandom().nextInt(PathfinderGoalEndermanPickupBlock.reducedTickDelay(20)) == 0;
        }

        @Override
        public void tick() {
            RandomSource var0 = this.enderman.getRandom();
            World var1 = this.enderman.level();
            int var2 = MathHelper.floor(this.enderman.getX() - 2.0 + var0.nextDouble() * 4.0);
            int var3 = MathHelper.floor(this.enderman.getY() + var0.nextDouble() * 3.0);
            int var4 = MathHelper.floor(this.enderman.getZ() - 2.0 + var0.nextDouble() * 4.0);
            BlockPosition var5 = new BlockPosition(var2, var3, var4);
            IBlockData var6 = var1.getBlockState(var5);
            Vec3D var7 = new Vec3D((double)this.enderman.getBlockX() + 0.5, (double)var3 + 0.5, (double)this.enderman.getBlockZ() + 0.5);
            Vec3D var8 = new Vec3D((double)var2 + 0.5, (double)var3 + 0.5, (double)var4 + 0.5);
            MovingObjectPositionBlock var9 = var1.clip(new RayTrace(var7, var8, RayTrace.BlockCollisionOption.OUTLINE, RayTrace.FluidCollisionOption.NONE, this.enderman));
            boolean var10 = var9.getBlockPos().equals(var5);
            if (var6.is(TagsBlock.ENDERMAN_HOLDABLE) && var10) {
                var1.removeBlock(var5, false);
                var1.gameEvent(GameEvent.BLOCK_DESTROY, var5, GameEvent.a.of(this.enderman, var6));
                this.enderman.setCarriedBlock(var6.getBlock().defaultBlockState());
            }
        }
    }

    static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman enderman;
        @Nullable
        private EntityHuman pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final PathfinderTargetCondition startAggroTargetConditions;
        private final PathfinderTargetCondition continueAggroTargetConditions = PathfinderTargetCondition.forCombat().ignoreLineOfSight();
        private final Predicate<EntityLiving> isAngerInducing;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman var0, @Nullable Predicate<EntityLiving> var12) {
            super(var0, EntityHuman.class, 10, false, false, var12);
            this.enderman = var0;
            this.isAngerInducing = var1 -> (var0.isLookingAtMe((EntityHuman)var1) || var0.isAngryAt((EntityLiving)var1)) && !var0.hasIndirectPassenger((Entity)var1);
            this.startAggroTargetConditions = PathfinderTargetCondition.forCombat().range(this.getFollowDistance()).selector(this.isAngerInducing);
        }

        @Override
        public boolean canUse() {
            this.pendingTarget = this.enderman.level().getNearestPlayer(this.startAggroTargetConditions, this.enderman);
            return this.pendingTarget != null;
        }

        @Override
        public void start() {
            this.aggroTime = this.adjustedTickDelay(5);
            this.teleportTime = 0;
            this.enderman.setBeingStaredAt();
        }

        @Override
        public void stop() {
            this.pendingTarget = null;
            super.stop();
        }

        @Override
        public boolean canContinueToUse() {
            if (this.pendingTarget != null) {
                if (!this.isAngerInducing.test(this.pendingTarget)) {
                    return false;
                }
                this.enderman.lookAt(this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            if (this.target != null) {
                if (this.enderman.hasIndirectPassenger(this.target)) {
                    return false;
                }
                if (this.continueAggroTargetConditions.test(this.enderman, this.target)) {
                    return true;
                }
            }
            return super.canContinueToUse();
        }

        @Override
        public void tick() {
            if (this.enderman.getTarget() == null) {
                super.setTarget(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.target = this.pendingTarget;
                    this.pendingTarget = null;
                    super.start();
                }
            } else {
                if (this.target != null && !this.enderman.isPassenger()) {
                    if (this.enderman.isLookingAtMe((EntityHuman)this.target)) {
                        if (this.target.distanceToSqr(this.enderman) < 16.0) {
                            this.enderman.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.target.distanceToSqr(this.enderman) > 256.0 && this.teleportTime++ >= this.adjustedTickDelay(30) && this.enderman.teleportTowards(this.target)) {
                        this.teleportTime = 0;
                    }
                }
                super.tick();
            }
        }
    }
}

