/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public final class AttributeModifier
extends Record {
    private final UUID id;
    public final String name;
    private final double amount;
    private final Operation operation;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<AttributeModifier> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(AttributeModifier::id), (App)Codec.STRING.fieldOf("name").forGetter(var0 -> var0.name), (App)Codec.DOUBLE.fieldOf("amount").forGetter(AttributeModifier::amount), (App)Operation.CODEC.fieldOf("operation").forGetter(AttributeModifier::operation)).apply((Applicative)var02, AttributeModifier::new));
    public static final Codec<AttributeModifier> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<ByteBuf, AttributeModifier> STREAM_CODEC = StreamCodec.composite(UUIDUtil.STREAM_CODEC, AttributeModifier::id, ByteBufCodecs.STRING_UTF8, var0 -> var0.name, ByteBufCodecs.DOUBLE, AttributeModifier::amount, Operation.STREAM_CODEC, AttributeModifier::operation, AttributeModifier::new);

    public AttributeModifier(String var0, double var1, Operation var3) {
        this(MathHelper.createInsecureUUID(RandomSource.createNewThreadLocalInstance()), var0, var1, var3);
    }

    public AttributeModifier(UUID var0, String var1, double var2, Operation var4) {
        this.id = var0;
        this.name = var1;
        this.amount = var2;
        this.operation = var4;
    }

    public NBTTagCompound save() {
        NBTTagCompound var0 = new NBTTagCompound();
        var0.putString("Name", this.name);
        var0.putDouble("Amount", this.amount);
        var0.putInt("Operation", this.operation.id());
        var0.putUUID("UUID", this.id);
        return var0;
    }

    @Nullable
    public static AttributeModifier load(NBTTagCompound var0) {
        try {
            UUID var1 = var0.getUUID("UUID");
            Operation var2 = Operation.BY_ID.apply(var0.getInt("Operation"));
            return new AttributeModifier(var1, var0.getString("Name"), var0.getDouble("Amount"), var2);
        }
        catch (Exception var1) {
            LOGGER.warn("Unable to create attribute: {}", (Object)var1.getMessage());
            return null;
        }
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{AttributeModifier.class, "id;name;amount;operation", "id", "name", "amount", "operation"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AttributeModifier.class, "id;name;amount;operation", "id", "name", "amount", "operation"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AttributeModifier.class, "id;name;amount;operation", "id", "name", "amount", "operation"}, this, var0);
    }

    public UUID id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public double amount() {
        return this.amount;
    }

    public Operation operation() {
        return this.operation;
    }

    public static final class Operation
    extends Enum<Operation>
    implements INamable {
        public static final /* enum */ Operation ADD_VALUE = new Operation("add_value", 0);
        public static final /* enum */ Operation ADD_MULTIPLIED_BASE = new Operation("add_multiplied_base", 1);
        public static final /* enum */ Operation ADD_MULTIPLIED_TOTAL = new Operation("add_multiplied_total", 2);
        public static final IntFunction<Operation> BY_ID;
        public static final StreamCodec<ByteBuf, Operation> STREAM_CODEC;
        public static final Codec<Operation> CODEC;
        private final String name;
        private final int id;
        private static final /* synthetic */ Operation[] i;

        public static Operation[] values() {
            return (Operation[])i.clone();
        }

        public static Operation valueOf(String var0) {
            return Enum.valueOf(Operation.class, var0);
        }

        private Operation(String var2, int var3) {
            this.name = var2;
            this.id = var3;
        }

        public int id() {
            return this.id;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Operation[] b() {
            return new Operation[]{ADD_VALUE, ADD_MULTIPLIED_BASE, ADD_MULTIPLIED_TOTAL};
        }

        static {
            i = Operation.b();
            BY_ID = ByIdMap.continuous(Operation::id, Operation.values(), ByIdMap.a.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Operation::id);
            CODEC = INamable.fromEnum(Operation::values);
        }
    }
}

