/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.phys.Vec3D;

public class EntityAttachments {
    private final Map<EntityAttachment, List<Vec3D>> attachments;

    EntityAttachments(Map<EntityAttachment, List<Vec3D>> var0) {
        this.attachments = var0;
    }

    public static EntityAttachments createDefault(float var0, float var1) {
        return EntityAttachments.builder().build(var0, var1);
    }

    public static a builder() {
        return new a();
    }

    public EntityAttachments scale(float var0, float var1, float var2) {
        EnumMap<EntityAttachment, List<Vec3D>> var3 = new EnumMap<EntityAttachment, List<Vec3D>>(EntityAttachment.class);
        for (Map.Entry<EntityAttachment, List<Vec3D>> var5 : this.attachments.entrySet()) {
            var3.put(var5.getKey(), EntityAttachments.scalePoints(var5.getValue(), var0, var1, var2));
        }
        return new EntityAttachments(var3);
    }

    private static List<Vec3D> scalePoints(List<Vec3D> var0, float var1, float var2, float var3) {
        ArrayList<Vec3D> var4 = new ArrayList<Vec3D>(var0.size());
        for (Vec3D var6 : var0) {
            var4.add(var6.multiply(var1, var2, var3));
        }
        return var4;
    }

    @Nullable
    public Vec3D getNullable(EntityAttachment var0, int var1, float var2) {
        List<Vec3D> var3 = this.attachments.get((Object)var0);
        if (var1 < 0 || var1 >= var3.size()) {
            return null;
        }
        return EntityAttachments.transformPoint(var3.get(var1), var2);
    }

    public Vec3D get(EntityAttachment var0, int var1, float var2) {
        Vec3D var3 = this.getNullable(var0, var1, var2);
        if (var3 == null) {
            throw new IllegalStateException("Had no attachment point of type: " + String.valueOf((Object)var0) + " for index: " + var1);
        }
        return var3;
    }

    public Vec3D getClamped(EntityAttachment var0, int var1, float var2) {
        List<Vec3D> var3 = this.attachments.get((Object)var0);
        if (var3.isEmpty()) {
            throw new IllegalStateException("Had no attachment points of type: " + String.valueOf((Object)var0));
        }
        Vec3D var4 = var3.get(MathHelper.clamp(var1, 0, var3.size() - 1));
        return EntityAttachments.transformPoint(var4, var2);
    }

    private static Vec3D transformPoint(Vec3D var0, float var1) {
        return var0.yRot(-var1 * ((float)Math.PI / 180));
    }

    public static class a {
        private final Map<EntityAttachment, List<Vec3D>> attachments = new EnumMap<EntityAttachment, List<Vec3D>>(EntityAttachment.class);

        a() {
        }

        public a attach(EntityAttachment var0, float var1, float var2, float var3) {
            return this.attach(var0, new Vec3D(var1, var2, var3));
        }

        public a attach(EntityAttachment var02, Vec3D var1) {
            this.attachments.computeIfAbsent(var02, var0 -> new ArrayList(1)).add(var1);
            return this;
        }

        public EntityAttachments build(float var0, float var1) {
            EnumMap<EntityAttachment, List<Vec3D>> var2 = new EnumMap<EntityAttachment, List<Vec3D>>(EntityAttachment.class);
            EntityAttachment[] entityAttachmentArray = EntityAttachment.values();
            int n2 = entityAttachmentArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                EntityAttachment var6;
                List<Vec3D> var7 = this.attachments.get((Object)(var6 = entityAttachmentArray[i2]));
                var2.put(var6, var7 != null ? List.copyOf(var7) : var6.createFallbackPoints(var0, var1));
            }
            return new EntityAttachments(var2);
        }
    }
}

