/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.function.ToIntFunction;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;

class OozingMobEffect
extends MobEffectList {
    private static final int RADIUS_TO_CHECK_SLIMES = 2;
    public static final int SLIME_SIZE = 2;
    private final ToIntFunction<RandomSource> spawnedCount;

    protected OozingMobEffect(MobEffectInfo var0, int var1, ToIntFunction<RandomSource> var2) {
        super(var0, var1, Particles.ITEM_SLIME);
        this.spawnedCount = var2;
    }

    @VisibleForTesting
    protected static int numberOfSlimesToSpawn(int var0, int var1, int var2) {
        return MathHelper.clamp(0, var0 - var1, var2);
    }

    @Override
    public void onMobRemoved(EntityLiving var0, int var12, Entity.RemovalReason var2) {
        if (var2 != Entity.RemovalReason.KILLED) {
            return;
        }
        int var3 = this.spawnedCount.applyAsInt(var0.getRandom());
        World var4 = var0.level();
        int var5 = var4.getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
        ArrayList var6 = new ArrayList();
        var4.getEntities(EntityTypes.SLIME, var0.getBoundingBox().inflate(2.0), var1 -> var1 != var0, var6, var5);
        int var7 = OozingMobEffect.numberOfSlimesToSpawn(var5, var6.size(), var3);
        for (int var8 = 0; var8 < var7; ++var8) {
            this.spawnSlimeOffspring(var0.level(), var0.getX(), var0.getY() + 0.5, var0.getZ());
        }
    }

    private void spawnSlimeOffspring(World var0, double var1, double var3, double var5) {
        EntitySlime var7 = EntityTypes.SLIME.create(var0);
        if (var7 == null) {
            return;
        }
        var7.setSize(2, true);
        var7.moveTo(var1, var3, var5, var0.getRandom().nextFloat() * 360.0f, 0.0f);
        var0.addFreshEntity(var7);
    }
}

