/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.AbsorptionMobEffect;
import net.minecraft.world.effect.BadOmenMobEffect;
import net.minecraft.world.effect.HealOrHarmMobEffect;
import net.minecraft.world.effect.HungerMobEffect;
import net.minecraft.world.effect.InfestedMobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.OozingMobEffect;
import net.minecraft.world.effect.PoisonMobEffect;
import net.minecraft.world.effect.RaidOmenMobEffect;
import net.minecraft.world.effect.RegenerationMobEffect;
import net.minecraft.world.effect.SaturationMobEffect;
import net.minecraft.world.effect.WeavingMobEffect;
import net.minecraft.world.effect.WindChargedMobEffect;
import net.minecraft.world.effect.WitherMobEffect;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.flag.FeatureFlags;

public class MobEffects {
    private static final int DARKNESS_EFFECT_FACTOR_PADDING_DURATION_TICKS = 22;
    public static final Holder<MobEffectList> MOVEMENT_SPEED = MobEffects.register("speed", new MobEffectList(MobEffectInfo.BENEFICIAL, 3402751).addAttributeModifier(GenericAttributes.MOVEMENT_SPEED, "91AEAA56-376B-4498-935B-2F7F68070635", 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffectList> MOVEMENT_SLOWDOWN = MobEffects.register("slowness", new MobEffectList(MobEffectInfo.HARMFUL, 9154528).addAttributeModifier(GenericAttributes.MOVEMENT_SPEED, "7107DE5E-7CE8-4030-940E-514C1F160890", -0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffectList> DIG_SPEED = MobEffects.register("haste", new MobEffectList(MobEffectInfo.BENEFICIAL, 14270531).addAttributeModifier(GenericAttributes.ATTACK_SPEED, "AF8B6E3F-3328-4C0A-AA36-5BA2BB9DBEF3", 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffectList> DIG_SLOWDOWN = MobEffects.register("mining_fatigue", new MobEffectList(MobEffectInfo.HARMFUL, 4866583).addAttributeModifier(GenericAttributes.ATTACK_SPEED, "55FCED67-E92A-486E-9800-B47F202C4386", -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffectList> DAMAGE_BOOST = MobEffects.register("strength", new MobEffectList(MobEffectInfo.BENEFICIAL, 16762624).addAttributeModifier(GenericAttributes.ATTACK_DAMAGE, "648D7064-6A60-4F59-8ABE-C2C23A6DD7A9", 3.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> HEAL = MobEffects.register("instant_health", new HealOrHarmMobEffect(MobEffectInfo.BENEFICIAL, 16262179, false));
    public static final Holder<MobEffectList> HARM = MobEffects.register("instant_damage", new HealOrHarmMobEffect(MobEffectInfo.HARMFUL, 11101546, true));
    public static final Holder<MobEffectList> JUMP = MobEffects.register("jump_boost", new MobEffectList(MobEffectInfo.BENEFICIAL, 16646020).addAttributeModifier(GenericAttributes.SAFE_FALL_DISTANCE, "C0105BF3-AEF8-46B0-9EBC-92943757CCBE", 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> CONFUSION = MobEffects.register("nausea", new MobEffectList(MobEffectInfo.HARMFUL, 5578058));
    public static final Holder<MobEffectList> REGENERATION = MobEffects.register("regeneration", new RegenerationMobEffect(MobEffectInfo.BENEFICIAL, 13458603));
    public static final Holder<MobEffectList> DAMAGE_RESISTANCE = MobEffects.register("resistance", new MobEffectList(MobEffectInfo.BENEFICIAL, 9520880));
    public static final Holder<MobEffectList> FIRE_RESISTANCE = MobEffects.register("fire_resistance", new MobEffectList(MobEffectInfo.BENEFICIAL, 0xFF9900));
    public static final Holder<MobEffectList> WATER_BREATHING = MobEffects.register("water_breathing", new MobEffectList(MobEffectInfo.BENEFICIAL, 10017472));
    public static final Holder<MobEffectList> INVISIBILITY = MobEffects.register("invisibility", new MobEffectList(MobEffectInfo.BENEFICIAL, 0xF6F6F6));
    public static final Holder<MobEffectList> BLINDNESS = MobEffects.register("blindness", new MobEffectList(MobEffectInfo.HARMFUL, 2039587));
    public static final Holder<MobEffectList> NIGHT_VISION = MobEffects.register("night_vision", new MobEffectList(MobEffectInfo.BENEFICIAL, 12779366));
    public static final Holder<MobEffectList> HUNGER = MobEffects.register("hunger", new HungerMobEffect(MobEffectInfo.HARMFUL, 5797459));
    public static final Holder<MobEffectList> WEAKNESS = MobEffects.register("weakness", new MobEffectList(MobEffectInfo.HARMFUL, 0x484D48).addAttributeModifier(GenericAttributes.ATTACK_DAMAGE, "22653B89-116E-49DC-9B6B-9971489B5BE5", -4.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> POISON = MobEffects.register("poison", new PoisonMobEffect(MobEffectInfo.HARMFUL, 8889187));
    public static final Holder<MobEffectList> WITHER = MobEffects.register("wither", new WitherMobEffect(MobEffectInfo.HARMFUL, 7561558));
    public static final Holder<MobEffectList> HEALTH_BOOST = MobEffects.register("health_boost", new MobEffectList(MobEffectInfo.BENEFICIAL, 16284963).addAttributeModifier(GenericAttributes.MAX_HEALTH, "5D6F0BA2-1186-46AC-B896-C61C5CEE99CC", 4.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> ABSORPTION = MobEffects.register("absorption", new AbsorptionMobEffect(MobEffectInfo.BENEFICIAL, 0x2552A5).addAttributeModifier(GenericAttributes.MAX_ABSORPTION, "EAE29CF0-701E-4ED6-883A-96F798F3DAB5", 4.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> SATURATION = MobEffects.register("saturation", new SaturationMobEffect(MobEffectInfo.BENEFICIAL, 16262179));
    public static final Holder<MobEffectList> GLOWING = MobEffects.register("glowing", new MobEffectList(MobEffectInfo.NEUTRAL, 9740385));
    public static final Holder<MobEffectList> LEVITATION = MobEffects.register("levitation", new MobEffectList(MobEffectInfo.HARMFUL, 0xCEFFFF));
    public static final Holder<MobEffectList> LUCK = MobEffects.register("luck", new MobEffectList(MobEffectInfo.BENEFICIAL, 5882118).addAttributeModifier(GenericAttributes.LUCK, "03C3C89D-7037-4B42-869F-B146BCB64D2E", 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> UNLUCK = MobEffects.register("unluck", new MobEffectList(MobEffectInfo.HARMFUL, 12624973).addAttributeModifier(GenericAttributes.LUCK, "CC5AF142-2BD2-4215-B636-2605AED11727", -1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffectList> SLOW_FALLING = MobEffects.register("slow_falling", new MobEffectList(MobEffectInfo.BENEFICIAL, 15978425));
    public static final Holder<MobEffectList> CONDUIT_POWER = MobEffects.register("conduit_power", new MobEffectList(MobEffectInfo.BENEFICIAL, 1950417));
    public static final Holder<MobEffectList> DOLPHINS_GRACE = MobEffects.register("dolphins_grace", new MobEffectList(MobEffectInfo.BENEFICIAL, 8954814));
    public static final Holder<MobEffectList> BAD_OMEN = MobEffects.register("bad_omen", new BadOmenMobEffect(MobEffectInfo.NEUTRAL, 745784).withSoundOnAdded(SoundEffects.APPLY_EFFECT_BAD_OMEN));
    public static final Holder<MobEffectList> HERO_OF_THE_VILLAGE = MobEffects.register("hero_of_the_village", new MobEffectList(MobEffectInfo.BENEFICIAL, 0x44FF44));
    public static final Holder<MobEffectList> DARKNESS = MobEffects.register("darkness", new MobEffectList(MobEffectInfo.HARMFUL, 2696993).setBlendDuration(22));
    public static final Holder<MobEffectList> TRIAL_OMEN = MobEffects.register("trial_omen", new MobEffectList(MobEffectInfo.NEUTRAL, 0x16A6A6, Particles.TRIAL_OMEN).withSoundOnAdded(SoundEffects.APPLY_EFFECT_TRIAL_OMEN).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffectList> RAID_OMEN = MobEffects.register("raid_omen", new RaidOmenMobEffect(MobEffectInfo.NEUTRAL, 14565464, Particles.RAID_OMEN).withSoundOnAdded(SoundEffects.APPLY_EFFECT_RAID_OMEN).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffectList> WIND_CHARGED = MobEffects.register("wind_charged", new WindChargedMobEffect(MobEffectInfo.HARMFUL, 12438015).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffectList> WEAVING = MobEffects.register("weaving", new WeavingMobEffect(MobEffectInfo.HARMFUL, 7891290, var0 -> MathHelper.randomBetweenInclusive(var0, 2, 3)).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffectList> OOZING = MobEffects.register("oozing", new OozingMobEffect(MobEffectInfo.HARMFUL, 10092451, var0 -> 2).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffectList> INFESTED = MobEffects.register("infested", new InfestedMobEffect(MobEffectInfo.HARMFUL, 9214860, 0.1f, var0 -> MathHelper.randomBetweenInclusive(var0, 1, 2)).requiredFeatures(FeatureFlags.UPDATE_1_21));

    private static Holder<MobEffectList> register(String var0, MobEffectList var1) {
        return IRegistry.registerForHolder(BuiltInRegistries.MOB_EFFECT, new MinecraftKey(var0), var1);
    }

    public static Holder<MobEffectList> bootstrap(IRegistry<MobEffectList> var0) {
        return MOVEMENT_SPEED;
    }
}

