/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlags;

class BadOmenMobEffect
extends MobEffectList {
    protected BadOmenMobEffect(MobEffectInfo var0, int var1) {
        super(var0, var1);
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int var0, int var1) {
        return true;
    }

    @Override
    public boolean applyEffectTick(EntityLiving var0, int var1) {
        EntityPlayer var2;
        if (var0 instanceof EntityPlayer && !(var2 = (EntityPlayer)var0).isSpectator()) {
            Raid var4;
            WorldServer var3 = var2.serverLevel();
            if (!var3.enabledFeatures().contains(FeatureFlags.UPDATE_1_21)) {
                return this.legacyApplyEffectTick(var2, var3);
            }
            if (var3.getDifficulty() != EnumDifficulty.PEACEFUL && var3.isVillage(var2.blockPosition()) && ((var4 = var3.getRaidAt(var2.blockPosition())) == null || var4.getRaidOmenLevel() < var4.getMaxRaidOmenLevel())) {
                var2.addEffect(new MobEffect(MobEffects.RAID_OMEN, 600, var1));
                var2.setRaidOmenPosition(var2.blockPosition());
                return false;
            }
        }
        return true;
    }

    private boolean legacyApplyEffectTick(EntityPlayer var0, WorldServer var1) {
        BlockPosition var2 = var0.blockPosition();
        if (var1.getDifficulty() != EnumDifficulty.PEACEFUL && var1.isVillage(var2)) {
            return var1.getRaids().createOrExtendRaid(var0, var2) == null;
        }
        return true;
    }
}

