/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterZombie
extends DataConverterNamedEntity {
    private static final int PROFESSION_MAX = 6;
    private static final RandomSource RANDOM = RandomSource.create();

    public DataConverterZombie(Schema var0, boolean var1) {
        super(var0, var1, "EntityZombieVillagerTypeFix", DataConverterTypes.ENTITY, "Zombie");
    }

    public Dynamic<?> fixTag(Dynamic<?> var0) {
        if (var0.get("IsVillager").asBoolean(false)) {
            if (var0.get("ZombieType").result().isEmpty()) {
                int var1 = this.getVillagerProfession(var0.get("VillagerProfession").asInt(-1));
                if (var1 == -1) {
                    var1 = this.getVillagerProfession(RANDOM.nextInt(6));
                }
                var0 = var0.set("ZombieType", var0.createInt(var1));
            }
            var0 = var0.remove("IsVillager");
        }
        return var0;
    }

    private int getVillagerProfession(int var0) {
        if (var0 < 0 || var0 >= 6) {
            return -1;
        }
        return var0;
    }

    @Override
    protected Typed<?> fix(Typed<?> var0) {
        return var0.update(DSL.remainderFinder(), this::fixTag);
    }
}

