/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, a> states;

    private RecipeBookSettings(Map<RecipeBookType, a> var0) {
        this.states = var0;
    }

    public RecipeBookSettings() {
        this(SystemUtils.make(Maps.newEnumMap(RecipeBookType.class), var0 -> {
            for (RecipeBookType var4 : RecipeBookType.values()) {
                var0.put(var4, new a(false, false));
            }
        }));
    }

    public boolean isOpen(RecipeBookType var0) {
        return this.states.get((Object)((Object)var0)).open;
    }

    public void setOpen(RecipeBookType var0, boolean var1) {
        this.states.get((Object)((Object)var0)).open = var1;
    }

    public boolean isFiltering(RecipeBookType var0) {
        return this.states.get((Object)((Object)var0)).filtering;
    }

    public void setFiltering(RecipeBookType var0, boolean var1) {
        this.states.get((Object)((Object)var0)).filtering = var1;
    }

    public static RecipeBookSettings read(PacketDataSerializer var0) {
        EnumMap var1 = Maps.newEnumMap(RecipeBookType.class);
        for (RecipeBookType var5 : RecipeBookType.values()) {
            boolean var6 = var0.readBoolean();
            boolean var7 = var0.readBoolean();
            var1.put(var5, new a(var6, var7));
        }
        return new RecipeBookSettings(var1);
    }

    public void write(PacketDataSerializer var0) {
        for (RecipeBookType var4 : RecipeBookType.values()) {
            a var5 = this.states.get((Object)var4);
            if (var5 == null) {
                var0.writeBoolean(false);
                var0.writeBoolean(false);
                continue;
            }
            var0.writeBoolean(var5.open);
            var0.writeBoolean(var5.filtering);
        }
    }

    public static RecipeBookSettings read(NBTTagCompound var0) {
        EnumMap var1 = Maps.newEnumMap(RecipeBookType.class);
        TAG_FIELDS.forEach((var2, var3) -> {
            boolean var4 = var0.getBoolean((String)var3.getFirst());
            boolean var5 = var0.getBoolean((String)var3.getSecond());
            var1.put(var2, new a(var4, var5));
        });
        return new RecipeBookSettings(var1);
    }

    public void write(NBTTagCompound var0) {
        TAG_FIELDS.forEach((var1, var2) -> {
            a var3 = this.states.get(var1);
            var0.putBoolean((String)var2.getFirst(), var3.open);
            var0.putBoolean((String)var2.getSecond(), var3.filtering);
        });
    }

    public RecipeBookSettings copy() {
        EnumMap var0 = Maps.newEnumMap(RecipeBookType.class);
        for (RecipeBookType var4 : RecipeBookType.values()) {
            a var5 = this.states.get((Object)var4);
            var0.put(var4, var5.copy());
        }
        return new RecipeBookSettings(var0);
    }

    public void replaceFrom(RecipeBookSettings var0) {
        this.states.clear();
        for (RecipeBookType var4 : RecipeBookType.values()) {
            a var5 = var0.states.get((Object)var4);
            this.states.put(var4, var5.copy());
        }
    }

    public boolean equals(Object var0) {
        return this == var0 || var0 instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)var0).states);
    }

    public int hashCode() {
        return this.states.hashCode();
    }

    static final class a {
        boolean open;
        boolean filtering;

        public a(boolean var0, boolean var1) {
            this.open = var0;
            this.filtering = var1;
        }

        public a copy() {
            return new a(this.open, this.filtering);
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 instanceof a) {
                a var1 = (a)var0;
                return this.open == var1.open && this.filtering == var1.filtering;
            }
            return false;
        }

        public int hashCode() {
            int var0 = this.open ? 1 : 0;
            var0 = 31 * var0 + (this.filtering ? 1 : 0);
            return var0;
        }

        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }
    }
}

